"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotesList = exports.DELETE_NOTE = exports.ADDED_A_NOTE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _delete_confirm_modal = require("./delete_confirm_modal");
var _open_flyout_button = require("./open_flyout_button");
var _open_timeline_button = require("./open_timeline_button");
var _delete_note_button = require("./delete_note_button");
var _markdown_editor = require("../../common/components/markdown_editor");
var _test_ids = require("./test_ids");
var _notes = require("../store/notes.slice");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADDED_A_NOTE = exports.ADDED_A_NOTE = _i18n.i18n.translate('xpack.securitySolution.notes.addedANoteLabel', {
  defaultMessage: 'added a note'
});
const DELETE_NOTE = exports.DELETE_NOTE = _i18n.i18n.translate('xpack.securitySolution.notes.deleteNoteLabel', {
  defaultMessage: 'Delete note'
});
/**
 * Renders a list of notes for the document.
 * If a note belongs to a timeline, a timeline icon will be shown the top right corner.
 * Also, a delete icon is shown in the top right corner to delete a note.
 * When a note is being created, the component renders a loading spinner when the new note is about to be added.
 */
const NotesList = exports.NotesList = /*#__PURE__*/(0, _react.memo)(({
  notes,
  options
}) => {
  const createStatus = (0, _reactRedux.useSelector)(state => (0, _notes.selectCreateNoteStatus)(state));
  const pendingDeleteIds = (0, _reactRedux.useSelector)(_notes.selectNotesTablePendingDeleteIds);
  const isDeleteModalVisible = pendingDeleteIds.length > 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCommentList, null, notes.map((note, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiComment, {
    "data-test-subj": `${_test_ids.NOTES_COMMENT_TEST_ID}-${index}`,
    key: note.noteId,
    username: note.createdBy,
    timestamp: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, note.created && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
      value: new Date(note.created)
    })),
    event: ADDED_A_NOTE,
    actions: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, note.eventId && !(options !== null && options !== void 0 && options.hideFlyoutIcon) && /*#__PURE__*/_react.default.createElement(_open_flyout_button.OpenFlyoutButtonIcon, {
      eventId: note.eventId,
      timelineId: note.timelineId,
      iconType: "arrowRight"
    }), note.timelineId && note.timelineId.length > 0 && !(options !== null && options !== void 0 && options.hideTimelineIcon) && /*#__PURE__*/_react.default.createElement(_open_timeline_button.OpenTimelineButtonIcon, {
      note: note,
      index: index
    }), /*#__PURE__*/_react.default.createElement(_delete_note_button.DeleteNoteButtonIcon, {
      note: note,
      index: index
    })),
    timelineAvatar: /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      "data-test-subj": `${_test_ids.NOTE_AVATAR_TEST_ID}-${index}`,
      size: "l",
      name: note.updatedBy || '?'
    })
  }, /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownRenderer, null, note.note || ''))), createStatus === _notes.ReqStatus.Loading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
    size: "xxl",
    "data-test-subj": _test_ids.ADD_NOTE_LOADING_TEST_ID
  })), isDeleteModalVisible && /*#__PURE__*/_react.default.createElement(_delete_confirm_modal.DeleteConfirmModal, {
    refetch: false
  }));
});
NotesList.displayName = 'NotesList';