"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowInsightsResults = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _user_privileges = require("../../../../../../../common/components/user_privileges");
var _translations = require("../../../translations");
var _routing = require("../../../../../../common/routing");
var _kibana = require("../../../../../../../common/lib/kibana");
var _constants = require("../../../../../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomEuiCallOut = (0, _styledComponents.default)(_eui.EuiCallOut)`
  & .euiButtonIcon {
    margin-top: 5px; /* Lower the close button */
  }
`;
const ScrollableContainer = (0, _styledComponents.default)(_eui.EuiPanel)`
  max-height: 500px;
  overflow-y: auto;
  padding: 0;
`;
const WorkflowInsightsResults = ({
  results,
  scanCompleted,
  endpointId
}) => {
  const [showEmptyResultsCallout, setShowEmptyResultsCallout] = (0, _react.useState)(false);
  const hideEmptyStateCallout = () => setShowEmptyResultsCallout(false);
  const {
    application: {
      navigateToUrl
    }
  } = (0, _kibana.useKibana)().services;
  const {
    canWriteTrustedApplications
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  (0, _react.useEffect)(() => {
    setShowEmptyResultsCallout((results === null || results === void 0 ? void 0 : results.length) === 0 && scanCompleted);
  }, [results, scanCompleted]);
  const openArtifactCreationPage = (0, _react.useCallback)(({
    remediation,
    id
  }) => {
    const getUrlBasedOnListId = listId => {
      switch (listId) {
        case _securitysolutionListConstants.ENDPOINT_ARTIFACT_LISTS.trustedApps.id:
        default:
          return _constants.TRUSTED_APPS_PATH;
      }
    };
    const url = `${_constants.APP_PATH}${getUrlBasedOnListId(remediation.list_id)}?show=create`;
    const state = {
      insight: {
        id,
        back_url: `${_constants.APP_PATH}${(0, _routing.getEndpointDetailsPath)({
          name: 'endpointDetails',
          selected_endpoint: endpointId
        })}`,
        item: {
          comments: [],
          description: remediation.description,
          entries: remediation.entries,
          list_id: remediation.list_id,
          name: remediation.name,
          namespace_type: 'agnostic',
          tags: remediation.tags,
          type: 'simple',
          os_types: remediation.os_types
        }
      }
    };
    navigateToUrl(url, {
      state
    });
  }, [endpointId, navigateToUrl]);
  const insights = (0, _react.useMemo)(() => {
    if (showEmptyResultsCallout) {
      return /*#__PURE__*/_react.default.createElement(CustomEuiCallOut, {
        onDismiss: hideEmptyStateCallout,
        color: 'success'
      }, _translations.WORKFLOW_INSIGHTS.issues.emptyResults);
    } else if (results !== null && results !== void 0 && results.length) {
      return results.flatMap((insight, index) => {
        var _insight$remediation$;
        return ((_insight$remediation$ = insight.remediation.exception_list_items) !== null && _insight$remediation$ !== void 0 ? _insight$remediation$ : []).map(item => {
          const {
            ariaLabel,
            tooltipContent,
            tooltipNoPermissions
          } = _translations.WORKFLOW_INSIGHTS.issues.remediationButton;
          return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
            paddingSize: "m",
            hasShadow: false,
            hasBorder: true,
            key: index
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            alignItems: 'center',
            gutterSize: 'm'
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "warning",
            size: "l",
            color: "warning"
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: 's'
          }, /*#__PURE__*/_react.default.createElement("strong", null, insight.metadata.display_name || insight.value)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: 's',
            color: 'subdued'
          }, insight.message), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: 'xs',
            color: 'subdued',
            css: 'word-break: break-word'
          }, item.entries[0].type === 'match' && item.entries[0].field === 'process.executable.caseless' && item.entries[0].value))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            style: {
              marginLeft: 'auto'
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: canWriteTrustedApplications ? tooltipContent : tooltipNoPermissions,
            position: 'top'
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            isDisabled: !canWriteTrustedApplications,
            "aria-label": ariaLabel,
            iconType: "popout",
            href: `${_constants.APP_PATH}${_constants.TRUSTED_APPS_PATH}?show=create`,
            onClick: e => {
              e.preventDefault();
              if (insight.id) {
                openArtifactCreationPage({
                  remediation: item,
                  id: insight.id
                });
              }
            }
          })))));
        });
      });
    }
    return null;
  }, [canWriteTrustedApplications, openArtifactCreationPage, results, showEmptyResultsCallout]);
  const showInsights = !!(showEmptyResultsCallout || results !== null && results !== void 0 && results.length);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showInsights && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 's'
  }, /*#__PURE__*/_react.default.createElement("h4", null, _translations.WORKFLOW_INSIGHTS.issues.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's'
  })), /*#__PURE__*/_react.default.createElement(ScrollableContainer, {
    hasBorder: true
  }, insights), showInsights && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null));
};
exports.WorkflowInsightsResults = WorkflowInsightsResults;