"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateEndpointPolicy = void 0;
var _reactQuery = require("@kbn/react-query");
var _common = require("@kbn/fleet-plugin/common");
var _policy = require("../../../../common/endpoint/service/policy");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUpdateEndpointPolicy = options => {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useMutation)(({
    policy
  }) => {
    const update = (0, _policy.getPolicyDataForUpdate)(policy);
    return http.put(_common.packagePolicyRouteService.getUpdatePath(policy.id), {
      body: JSON.stringify(update),
      version: _common.API_VERSIONS.public.v1
    });
  }, options);
};
exports.useUpdateEndpointPolicy = useUpdateEndpointPolicy;