"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSetUrlParams = void 0;
var _reactRouterDom = require("react-router-dom");
var _react = require("react");
var _lodash = require("lodash");
var _use_url_params = require("../../../hooks/use_url_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// FIXME:PT Refactor into a more generic hooks for managing url params
const useSetUrlParams = () => {
  const location = (0, _reactRouterDom.useLocation)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    toUrlParams,
    urlParams: currentUrlParams
  } = (0, _use_url_params.useUrlParams)();
  return (0, _react.useCallback)((params, replace = false) => {
    history.push({
      ...location,
      search: toUrlParams(replace ? params : (0, _lodash.pickBy)({
        ...currentUrlParams,
        ...params
      }, value => value !== undefined))
    });
  }, [currentUrlParams, history, location, toUrlParams]);
};
exports.useSetUrlParams = useSetUrlParams;