"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMemoizedRouteState = useMemoizedRouteState;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMemoizedRouteState(routeState) {
  const [memoizedRouteState, setMemoizedRouteState] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    // At some point we would like to check if the path has changed or not to keep this consistent across different pages
    if (routeState && routeState.onBackButtonNavigateTo) {
      setMemoizedRouteState(routeState);
    }
  }, [routeState]);
  return memoizedRouteState;
}