"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useObservedServiceDetails = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _use_search_strategy = require("../../../../common/containers/use_search_strategy");
var _services = require("../../../../../common/search_strategy/security_solution/services");
var _content = require("../content");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useObservedServiceDetails = ({
  endDate,
  serviceName,
  indexNames,
  id = _content.OBSERVED_SERVICE_QUERY_ID,
  skip = false,
  startDate
}) => {
  const {
    loading,
    result: response,
    search,
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _services.ServicesQueries.observedDetails,
    initialResult: {
      serviceDetails: {}
    },
    errorMessage: _i18n.i18n.translate('xpack.securitySolution.serviceDetails.failSearchDescription', {
      defaultMessage: `Failed to run search on service details`
    }),
    abort: skip
  });
  const serviceDetailsResponse = (0, _react.useMemo)(() => ({
    endDate,
    serviceDetails: response.serviceDetails,
    id,
    inspect,
    refetch,
    startDate
  }), [endDate, id, inspect, refetch, response.serviceDetails, startDate]);
  const serviceDetailsRequest = (0, _react.useMemo)(() => ({
    defaultIndex: indexNames,
    factoryQueryType: _services.ServicesQueries.observedDetails,
    serviceName,
    timerange: {
      interval: '12h',
      from: startDate,
      to: endDate
    }
  }), [endDate, indexNames, startDate, serviceName]);
  (0, _react.useEffect)(() => {
    if (!skip) {
      search(serviceDetailsRequest);
    }
  }, [serviceDetailsRequest, search, skip]);
  return [loading, serviceDetailsResponse];
};
exports.useObservedServiceDetails = useObservedServiceDetails;