"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServicePanelHeader = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _search_strategy = require("../../../../common/search_strategy");
var _helpers = require("../../../entity_analytics/components/entity_store/helpers");
var _formatted_date = require("../../../common/components/formatted_date");
var _flyout_header = require("../../shared/components/flyout_header");
var _flyout_title = require("../../shared/components/flyout_title");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ServicePanelHeader = ({
  serviceName,
  observedService
}) => {
  const lastSeenDate = (0, _react.useMemo)(() => observedService.lastSeen.date && new Date(observedService.lastSeen.date), [observedService.lastSeen]);
  return /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, {
    "data-test-subj": "service-panel-header"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": 'service-panel-header-lastSeen'
  }, lastSeenDate && /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
    value: lastSeenDate
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_flyout_title.FlyoutTitle, {
    title: serviceName,
    iconType: _helpers.EntityIconByType[_search_strategy.EntityType.service]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, observedService.lastSeen.date && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "service-panel-header-observed-badge",
    color: "hollow"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.service.observedBadge",
    defaultMessage: "Observed"
  })))))));
};
exports.ServicePanelHeader = ServicePanelHeader;