"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_expand_section = require("../hooks/use_expand_section");
var _response_button = require("./response_button");
var _expandable_section = require("./expandable_section");
var _context = require("../../shared/context");
var _utils = require("../../shared/utils");
var _event_kinds = require("../../shared/constants/event_kinds");
var _test_ids = require("./test_ids");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KEY = 'response';

/**
 * Most bottom section of the overview tab. It contains a summary of the response tab.
 */
const ResponseSection = exports.ResponseSection = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    isRulePreview,
    getFieldsData,
    isPreviewMode
  } = (0, _context.useDocumentDetailsContext)();
  const expanded = (0, _use_expand_section.useExpandSection)({
    title: KEY,
    defaultValue: false
  });
  const eventKind = (0, _utils.getField)(getFieldsData('event.kind'));
  const isNewNavigationEnabled = !(0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newExpandableFlyoutNavigationDisabled');
  const content = (0, _react.useMemo)(() => {
    if (isRulePreview) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        iconType: "documentation",
        size: "s",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.right.response.previewTitle",
          defaultMessage: "Response actions"
        }),
        "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.response.previewAriaLabel', {
          defaultMessage: 'Response actions'
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.response.previewMessage",
        defaultMessage: "Response is not available in alert preview."
      }));
    }
    if (!isNewNavigationEnabled && isPreviewMode) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        iconType: "documentation",
        size: "s",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.right.response.openFlyoutTitle",
          defaultMessage: "Response actions"
        }),
        "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.response.openFlyoutAriaLabel', {
          defaultMessage: 'Response actions'
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.response.openFlyoutMessage",
        defaultMessage: "Open alert details to access response actions."
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_response_button.ResponseButton, null);
  }, [isRulePreview, isPreviewMode, isNewNavigationEnabled]);
  if (eventKind !== _event_kinds.EventKind.signal) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    expanded: expanded,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.response.sectionTitle",
      defaultMessage: "Response"
    }),
    localStorageKey: KEY,
    "data-test-subj": _test_ids.RESPONSE_SECTION_TEST_ID
  }, content);
});
ResponseSection.displayName = 'ResponseSection';