"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MitreAttack = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _helpers = require("../../../../detection_engine/rule_creation_ui/components/description_step/helpers");
var _context = require("../../shared/context");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieves mitre attack information from the alert information
 */
const getMitreComponentParts = searchHit => {
  var _ruleParameters$;
  const ruleParameters = searchHit !== null && searchHit !== void 0 && searchHit.fields ? searchHit === null || searchHit === void 0 ? void 0 : searchHit.fields['kibana.alert.rule.parameters'] : null;
  const threat = ruleParameters ? (_ruleParameters$ = ruleParameters[0]) === null || _ruleParameters$ === void 0 ? void 0 : _ruleParameters$.threat : null;
  if (!threat) {
    return null;
  }
  const threats = Array.isArray(threat) ? threat : [threat];
  return (0, _helpers.buildThreatDescription)({
    label: threats[0].framework,
    threat: threats
  });
};
const MitreAttack = () => {
  const {
    searchHit
  } = (0, _context.useDocumentDetailsContext)();
  const threatDetails = (0, _react.useMemo)(() => getMitreComponentParts(searchHit), [searchHit]);
  if (!threatDetails || !threatDetails[0]) {
    // Do not render empty message on MITRE attack because other frameworks could be used
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.MITRE_ATTACK_TITLE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, threatDetails[0].title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.MITRE_ATTACK_DETAILS_TEST_ID
  }, threatDetails[0].description));
};
exports.MitreAttack = MitreAttack;
MitreAttack.displayName = 'MitreAttack';