"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatIntelligenceDetails = exports.THREAT_INTELLIGENCE_TAB_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _isEmpty = _interopRequireDefault(require("lodash/isEmpty"));
var _lodash = require("lodash");
var _threat_details_view_enrichment_section = require("./threat_details_view_enrichment_section");
var _constants = require("../../../../../common/cti/constants");
var _threat_intelligence_view_enrichment_range_picker = require("./threat_intelligence_view_enrichment_range_picker");
var _use_threat_intelligence_details = require("../hooks/use_threat_intelligence_details");
var _test_ids = require("./test_ids");
var _flyout_loading = require("../../../shared/components/flyout_loading");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const THREAT_INTELLIGENCE_TAB_ID = exports.THREAT_INTELLIGENCE_TAB_ID = 'threatIntelligence';

/**
 * Threat intelligence displayed in the document details expandable flyout left section under the Insights tab
 */
const ThreatIntelligenceDetails = exports.ThreatIntelligenceDetails = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    enrichments,
    eventFields,
    isEnrichmentsLoading,
    isEventDataLoading,
    isLoading,
    range,
    setRange
  } = (0, _use_threat_intelligence_details.useThreatIntelligenceDetails)();
  const showInvestigationTimeEnrichments = !(0, _isEmpty.default)(eventFields);
  const {
    [_constants.ENRICHMENT_TYPES.IndicatorMatchRule]: indicatorMatches,
    [_constants.ENRICHMENT_TYPES.InvestigationTime]: threatIntelEnrichments,
    undefined: matchesWithNoType
  } = (0, _lodash.groupBy)(enrichments, 'matched.type');
  return isEventDataLoading ? /*#__PURE__*/_react.default.createElement(_flyout_loading.FlyoutLoading, {
    "data-test-subj": _test_ids.THREAT_INTELLIGENCE_DETAILS_LOADING_TEST_ID
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_threat_details_view_enrichment_section.EnrichmentSection, {
    dataTestSubj: _test_ids.THREAT_INTELLIGENCE_DETAILS_ENRICHMENTS_TEST_ID,
    enrichments: indicatorMatches,
    type: _constants.ENRICHMENT_TYPES.IndicatorMatchRule
  }), showInvestigationTimeEnrichments ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_threat_details_view_enrichment_section.EnrichmentSection, {
    dataTestSubj: _test_ids.THREAT_INTELLIGENCE_ENRICHMENTS_TEST_ID,
    enrichments: threatIntelEnrichments,
    type: _constants.ENRICHMENT_TYPES.InvestigationTime,
    loading: isLoading
  }, /*#__PURE__*/_react.default.createElement(_threat_intelligence_view_enrichment_range_picker.EnrichmentRangePicker, {
    setRange: setRange,
    loading: isEnrichmentsLoading,
    range: range
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }))) : null, matchesWithNoType ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), indicatorMatches && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_threat_details_view_enrichment_section.EnrichmentSection, {
    enrichments: matchesWithNoType,
    dataTestSubj: _test_ids.THREAT_INTELLIGENCE_MATCHES_TEST_ID
  })) : null);
});
ThreatIntelligenceDetails.displayName = 'ThreatIntelligenceDetails';