"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnrichmentButtonContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FEED_NAME_PREPOSITION = _i18n.i18n.translate('xpack.securitySolution.flyout.threatIntelligence.feedNamePreposition', {
  defaultMessage: 'from'
});
const OverflowParent = _styledComponents.default.div`
  display: inline-grid;
`;
const OverflowContainer = _styledComponents.default.div`
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
  font-weight: bold;
`;
/**
 * Displays the content of the button rendered in the accordion
 */
const EnrichmentButtonContent = exports.EnrichmentButtonContent = /*#__PURE__*/(0, _react.memo)(({
  field = '',
  feedName = '',
  value = ''
}) => {
  const title = `${field} ${value}${feedName ? ` ${FEED_NAME_PREPOSITION} ${feedName}` : ''}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: value
  }, /*#__PURE__*/_react.default.createElement(OverflowParent, {
    "data-test-subj": _test_ids.THREAT_INTELLIGENCE_ENRICHMENTS_BUTTON_CONTENT_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(OverflowContainer, null, title)));
});
EnrichmentButtonContent.displayName = 'EnrichmentButtonContent';