"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUGGESTED_PROMPTS_SECTION_TEST_ID = exports.AI_ASSISTANT_SECTION_TEST_ID = exports.AIAssistantSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _suggested_prompts = require("./suggested_prompts");
var _utils = require("../../document_details/shared/utils");
var _context = require("../context");
var _conversations = require("./conversations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AI_ASSISTANT_SECTION_TEST_ID = exports.AI_ASSISTANT_SECTION_TEST_ID = 'ai-for-soc-alert-flyout-ai-assistant-section';
const SUGGESTED_PROMPTS_SECTION_TEST_ID = exports.SUGGESTED_PROMPTS_SECTION_TEST_ID = 'ai-for-soc-alert-flyout-suggested-prompts-section';
const AI_ASSISTANT = _i18n.i18n.translate('xpack.securitySolution.aiAssistantSection.title', {
  defaultMessage: 'AI Assistant'
});
const SUGGESTED_PROMPTS = _i18n.i18n.translate('xpack.securitySolution.alertSummary.suggestedPromptsSection.title', {
  defaultMessage: 'Suggested prompts'
});
/**
 * Panel to be displayed in AI for SOC alert summary flyout
 */
const AIAssistantSection = exports.AIAssistantSection = /*#__PURE__*/(0, _react.memo)(({
  getPromptContext
}) => {
  const {
    eventId,
    getFieldsData
  } = (0, _context.useAIForSOCDetailsContext)();
  const ruleName = (0, _react.useMemo)(() => (0, _utils.getField)(getFieldsData(_ruleDataUtils.ALERT_RULE_NAME)) || '', [getFieldsData]);
  const timestamp = (0, _react.useMemo)(() => (0, _utils.getField)(getFieldsData(_ruleDataUtils.TIMESTAMP)) || '', [getFieldsData]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": AI_ASSISTANT_SECTION_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: 's'
  }, /*#__PURE__*/_react.default.createElement("h2", null, AI_ASSISTANT)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_conversations.Conversations, {
    alertId: eventId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": SUGGESTED_PROMPTS_SECTION_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, SUGGESTED_PROMPTS)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_suggested_prompts.SuggestedPrompts, {
    getPromptContext: getPromptContext,
    ruleName: ruleName,
    timestamp: timestamp
  })));
});
AIAssistantSection.displayName = 'AIAssistantSection';