"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Explore = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _routes = require("./routes");
var _store = require("./network/store");
var _local_storage = require("../timelines/containers/local_storage");
var _store2 = require("./users/store");
var _store3 = require("./hosts/store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Explore {
  setup() {}
  start(storage) {
    return {
      routes: _routes.routes,
      exploreDataTables: {
        network: {
          tableById: (0, _local_storage.getDataTablesInStorageByIds)(storage, [_securitysolutionDataTable.TableId.networkPageEvents])
        },
        hosts: {
          tableById: (0, _local_storage.getDataTablesInStorageByIds)(storage, [_securitysolutionDataTable.TableId.hostsPageEvents, _securitysolutionDataTable.TableId.hostsPageSessions])
        },
        users: {
          tableById: (0, _local_storage.getDataTablesInStorageByIds)(storage, [_securitysolutionDataTable.TableId.usersPageEvents])
        }
      },
      store: {
        initialState: {
          network: _store.initialNetworkState,
          users: (0, _store2.getInitialUsersState)(storage),
          hosts: _store3.initialHostsState
        },
        reducer: {
          network: _store.networkReducer,
          users: (0, _store2.makeUsersReducer)(storage),
          hosts: _store3.hostsReducer
        }
      }
    };
  }
}
exports.Explore = Explore;