"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatItemsComponent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _stat_item_header = require("./stat_item_header");
var _use_toggle_status = require("./use_toggle_status");
var _utils = require("./utils");
var _metric_embeddable = require("./metric_embeddable");
var _visualization_embeddable = require("../../../common/components/visualization_actions/visualization_embeddable");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatItemsComponent = exports.StatItemsComponent = /*#__PURE__*/_react.default.memo(({
  statItems,
  from,
  id,
  to
}) => {
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const {
    key,
    description,
    enableAreaChart,
    enableBarChart,
    fields,
    getBarChartLensAttributes,
    getAreaChartLensAttributes
  } = statItems;
  const {
    isToggleExpanded,
    onToggle
  } = (0, _use_toggle_status.useToggleStatus)({
    id
  });
  return /*#__PURE__*/_react.default.createElement(_utils.FlexItem, {
    grow: 1,
    "data-test-subj": key
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_stat_item_header.StatItemHeader, {
    onToggle: onToggle,
    isToggleExpanded: isToggleExpanded,
    description: description
  }), isToggleExpanded && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_metric_embeddable.MetricEmbeddable, {
    fields: fields,
    id: id,
    timerange: timerange,
    inspectTitle: description
  }), (enableAreaChart || enableBarChart) && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, enableBarChart && /*#__PURE__*/_react.default.createElement(_utils.FlexItem, null, /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    "data-test-subj": "embeddable-bar-chart",
    getLensAttributes: getBarChartLensAttributes,
    timerange: timerange,
    id: `${id}-bar-embeddable`,
    height: _utils.ChartHeight,
    inspectTitle: description
  })), enableAreaChart && from != null && to != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_utils.FlexItem, null, /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    "data-test-subj": "embeddable-area-chart",
    getLensAttributes: getAreaChartLensAttributes,
    timerange: timerange,
    id: `${id}-area-embeddable`,
    height: _utils.ChartHeight,
    inspectTitle: description
  })))))));
});
StatItemsComponent.displayName = 'StatItemsComponent';