"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityAnalyticsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../app/translations");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _types = require("../../app/types");
var _containers = require("../../sourcerer/containers");
var _page_wrapper = require("../../common/components/page_wrapper");
var _header_page = require("../../common/components/header_page");
var _empty_prompt = require("../../common/components/empty_prompt");
var _search_bar = require("../../common/components/search_bar");
var _constants = require("../../common/store/inputs/constants");
var _filters_global = require("../../common/components/filters_global");
var _use_risk_engine_status = require("../api/hooks/use_risk_engine_status");
var _risk_score_update_panel = require("../components/risk_score_update_panel");
var _helper_hooks = require("../../helper_hooks");
var _entity_analytics_header = require("../components/entity_analytics_header");
var _entity_analytics_anomalies = require("../components/entity_analytics_anomalies");
var _dashboard_entity_store_panels = require("../components/entity_store/components/dashboard_entity_store_panels");
var _entity_analytics_risk_score = require("../components/entity_analytics_risk_score");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _use_data_view = require("../../data_view_manager/hooks/use_data_view");
var _use_enabled_entity_types = require("../hooks/use_enabled_entity_types");
var _page_loader = require("../../common/components/page_loader");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntityAnalyticsComponent = () => {
  var _dataView$matchedIndi2;
  const {
    data: riskScoreEngineStatus
  } = (0, _use_risk_engine_status.useRiskEngineStatus)();
  const {
    indicesExist: oldIndicesExist,
    loading: oldIsSourcererLoading,
    sourcererDataView: oldSourcererDataViewSpec
  } = (0, _containers.useSourcererDataView)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView,
    status
  } = (0, _use_data_view.useDataView)();
  const indicesExist = (0, _react.useMemo)(() => {
    var _dataView$matchedIndi;
    return newDataViewPickerEnabled ? !!(dataView !== null && dataView !== void 0 && (_dataView$matchedIndi = dataView.matchedIndices) !== null && _dataView$matchedIndi !== void 0 && _dataView$matchedIndi.length) : oldIndicesExist;
  }, [dataView === null || dataView === void 0 ? void 0 : (_dataView$matchedIndi2 = dataView.matchedIndices) === null || _dataView$matchedIndi2 === void 0 ? void 0 : _dataView$matchedIndi2.length, newDataViewPickerEnabled, oldIndicesExist]);
  const isSourcererLoading = (0, _react.useMemo)(() => newDataViewPickerEnabled ? status !== 'ready' : oldIsSourcererLoading, [newDataViewPickerEnabled, oldIsSourcererLoading, status]);
  const isRiskScoreModuleLicenseAvailable = (0, _helper_hooks.useHasSecurityCapability)('entity-analytics');
  const isEntityStoreFeatureFlagDisabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('entityStoreDisabled');
  const entityTypes = (0, _use_enabled_entity_types.useStoreEntityTypes)();
  if (newDataViewPickerEnabled && status === 'pristine') {
    return /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, null, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    id: _constants.InputsModelId.global,
    sourcererDataView: oldSourcererDataViewSpec // TODO: newDataViewPicker - Can be removed after migration to new dataview picker
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    "data-test-subj": "entityAnalyticsPage"
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: _translations.ENTITY_ANALYTICS
  }), isSourcererLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    "data-test-subj": "entityAnalyticsLoader"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "entityAnalyticsSections"
  }, (riskScoreEngineStatus === null || riskScoreEngineStatus === void 0 ? void 0 : riskScoreEngineStatus.isUpdateAvailable) && isRiskScoreModuleLicenseAvailable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_risk_score_update_panel.RiskScoreUpdatePanel, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_entity_analytics_header.EntityAnalyticsHeader, null)), !isEntityStoreFeatureFlagDisabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_dashboard_entity_store_panels.EntityStoreDashboardPanels, null)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, entityTypes.map(entityType => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: entityType
  }, /*#__PURE__*/_react.default.createElement(_entity_analytics_risk_score.EntityAnalyticsRiskScores, {
    riskEntity: entityType
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_entity_analytics_anomalies.EntityAnalyticsAnomalies, null))))) : /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.entityAnalytics
  }));
};
const EntityAnalyticsPage = exports.EntityAnalyticsPage = /*#__PURE__*/_react.default.memo(EntityAnalyticsComponent);