"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createIngestPipeline = createIngestPipeline;
exports.deleteIngestPipelines = deleteIngestPipelines;
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INGEST_PIPELINES_API_BASE_PATH = `/api/ingest_pipelines`;
async function createIngestPipeline({
  errorMessage,
  http,
  options,
  renderDocLink,
  signal,
  startServices: {
    notifications,
    ...startServices
  }
}) {
  const res = await http.post(INGEST_PIPELINES_API_BASE_PATH, {
    body: JSON.stringify(options),
    signal
  }).catch(e => {
    var _e$body, _e$body2;
    notifications.toasts.addDanger({
      title: errorMessage !== null && errorMessage !== void 0 ? errorMessage : _translations.INGEST_PIPELINE_CREATION_ERROR_MESSAGE,
      text: (0, _reactKibanaMount.toMountPoint)(renderDocLink ? renderDocLink(e === null || e === void 0 ? void 0 : (_e$body = e.body) === null || _e$body === void 0 ? void 0 : _e$body.message) : e === null || e === void 0 ? void 0 : (_e$body2 = e.body) === null || _e$body2 === void 0 ? void 0 : _e$body2.message, startServices)
    });
  });
  return res;
}
async function deleteIngestPipelines({
  errorMessage,
  http,
  names,
  // separate with ','
  renderDocLink,
  signal,
  startServices: {
    notifications,
    ...startServices
  }
}) {
  const count = names.split(',').length;
  const res = await http.delete(`${INGEST_PIPELINES_API_BASE_PATH}/${names}`, {
    signal
  }).catch(e => {
    var _e$body3, _e$body4;
    notifications.toasts.addDanger({
      title: errorMessage !== null && errorMessage !== void 0 ? errorMessage : (0, _translations.INGEST_PIPELINE_DELETION_ERROR_MESSAGE)(count),
      text: (0, _reactKibanaMount.toMountPoint)(renderDocLink ? renderDocLink(e === null || e === void 0 ? void 0 : (_e$body3 = e.body) === null || _e$body3 === void 0 ? void 0 : _e$body3.message) : e === null || e === void 0 ? void 0 : (_e$body4 = e.body) === null || _e$body4 === void 0 ? void 0 : _e$body4.message, startServices)
    });
  });
  return res;
}