"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnableRiskScore = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_check_signal_index = require("../../../detections/containers/detection_engine/alerts/use_check_signal_index");
var _risk_score_header_title = require("../risk_score_onboarding/risk_score_header_title");
var _header_section = require("../../../common/components/header_section");
var _entity_analytics_doc_link = require("../risk_score_onboarding/entity_analytics_doc_link");
var _risk_score_enable_button = require("../risk_score_onboarding/risk_score_enable_button");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnableRiskScoreComponent = ({
  isDeprecated,
  isDisabled,
  entityType,
  refetch,
  timerange
}) => {
  const {
    signalIndexExists
  } = (0, _use_check_signal_index.useCheckSignalIndex)();
  if (!isDeprecated && !isDisabled) {
    return null;
  }
  const text = isDeprecated ? {
    cta: i18n.UPGRADE_RISK_SCORE(entityType),
    body: i18n.UPGRADE_RISK_SCORE_DESCRIPTION
  } : {
    cta: i18n.ENABLE_RISK_SCORE(entityType),
    body: i18n.ENABLE_RISK_SCORE_DESCRIPTION(entityType)
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: /*#__PURE__*/_react.default.createElement(_risk_score_header_title.RiskScoreHeaderTitle, {
      riskScoreEntity: entityType
    }),
    titleSize: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, text.cta),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, text.body, ` `, /*#__PURE__*/_react.default.createElement(_entity_analytics_doc_link.EntityAnalyticsLearnMoreLink, null)),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: !signalIndexExists ? i18n.ENABLE_RISK_SCORE_POPOVER : null
    }, /*#__PURE__*/_react.default.createElement(_risk_score_enable_button.RiskScoreEnableButton, {
      disabled: !signalIndexExists,
      refetch: refetch,
      riskScoreEntity: entityType,
      timerange: timerange
    }))
  }));
};
const EnableRiskScore = exports.EnableRiskScore = /*#__PURE__*/_react.default.memo(EnableRiskScoreComponent);
EnableRiskScore.displayName = 'EnableRiskScore';