"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationSection = exports.CARD_TEST_ID = exports.ADD_INTEGRATIONS_BUTTON_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _integration_card = require("./integration_card");
var _use_navigate_to_integrations_page = require("../../../hooks/alert_summary/use_navigate_to_integrations_page");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_INTEGRATION = _i18n.i18n.translate('xpack.securitySolution.alertSummary.integrations.addIntegrationButtonLabel', {
  defaultMessage: 'Add integration'
});
const CARD_TEST_ID = exports.CARD_TEST_ID = 'alert-summary-integration-card-';
const ADD_INTEGRATIONS_BUTTON_TEST_ID = exports.ADD_INTEGRATIONS_BUTTON_TEST_ID = 'alert-summary-add-integrations-button';
/**
 * Section rendered at the top of the alert summary page. It displays all the AI for SOC installed integrations
 * and allow the user to add more integrations by clicking on a button that links to a Fleet page.
 * Each integration card is also displaying the last time the sync happened (using streams).
 */
const IntegrationSection = exports.IntegrationSection = /*#__PURE__*/(0, _react.memo)(({
  packages
}) => {
  const navigateToIntegrationsPage = (0, _use_navigate_to_integrations_page.useNavigateToIntegrationsPage)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    wrap: true
  }, packages.map(pkg => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: pkg.name
  }, /*#__PURE__*/_react.default.createElement(_integration_card.IntegrationCard, {
    "data-test-subj": `${CARD_TEST_ID}${pkg.name}`,
    integration: pkg
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": ADD_INTEGRATIONS_BUTTON_TEST_ID,
    iconType: "plusInCircle",
    onClick: navigateToIntegrationsPage
  }, ADD_INTEGRATION)));
});
IntegrationSection.displayName = 'IntegrationSection';