"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventTypeFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rule_monitoring = require("../../../../../../../common/api/detection_engine/rule_monitoring");
var _event_type_indicator = require("../../indicators/event_type_indicator");
var _multiselect_filter = require("../multiselect_filter");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EventTypeFilterComponent = ({
  selectedItems,
  onChange
}) => {
  const renderItem = (0, _react.useCallback)(item => {
    return /*#__PURE__*/_react.default.createElement(_event_type_indicator.EventTypeIndicator, {
      type: item
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_multiselect_filter.MultiselectFilter, {
    dataTestSubj: "eventTypeFilter",
    title: i18n.FILTER_TITLE,
    items: _rule_monitoring.RuleExecutionEventType.options,
    selectedItems: selectedItems,
    onSelectionChange: onChange,
    renderItem: renderItem
  });
};
const EventTypeFilter = exports.EventTypeFilter = /*#__PURE__*/_react.default.memo(EventTypeFilterComponent);
EventTypeFilter.displayName = 'EventTypeFilter';