"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradePrebuiltRulesTableButtons = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _user_info = require("../../../../../detections/components/user_info");
var i18n = _interopRequireWildcard(require("./translations"));
var _upgrade_prebuilt_rules_table_context = require("./upgrade_prebuilt_rules_table_context");
var _use_prebuilt_rules_customization_status = require("../../../../rule_management/logic/prebuilt_rules/use_prebuilt_rules_customization_status");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UpgradePrebuiltRulesTableButtons = ({
  selectedRules
}) => {
  var _selectedRules$length;
  const {
    state: {
      hasRulesToUpgrade,
      loadingRules,
      isRefetching,
      isUpgradingSecurityPackages
    },
    actions: {
      upgradeRules,
      upgradeAllRules
    }
  } = (0, _upgrade_prebuilt_rules_table_context.useUpgradePrebuiltRulesTableContext)();
  const {
    isRulesCustomizationEnabled
  } = (0, _use_prebuilt_rules_customization_status.usePrebuiltRulesCustomizationStatus)();
  const [{
    loading: isUserDataLoading,
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const canUserEditRules = canUserCRUD && !isUserDataLoading;
  const numberOfSelectedRules = (_selectedRules$length = selectedRules.length) !== null && _selectedRules$length !== void 0 ? _selectedRules$length : 0;
  const shouldDisplayUpgradeSelectedRulesButton = numberOfSelectedRules > 0;
  const isRuleUpgrading = loadingRules.length > 0;
  const isRequestInProgress = isRuleUpgrading || isRefetching || isUpgradingSecurityPackages;
  const doAllSelectedRulesHaveConflicts = isRulesCustomizationEnabled && selectedRules.every(({
    hasNonSolvableUnresolvedConflicts
  }) => hasNonSolvableUnresolvedConflicts);
  const {
    selectedRulesButtonTooltip,
    allRulesButtonTooltip
  } = useBulkUpdateButtonsTooltipContent({
    canUserEditRules,
    doAllSelectedRulesHaveConflicts,
    isPrebuiltRulesCustomizationEnabled: isRulesCustomizationEnabled
  });
  const upgradeSelectedRules = (0, _react.useCallback)(() => upgradeRules(selectedRules.map(rule => rule.rule_id)), [selectedRules, upgradeRules]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    wrap: true
  }, shouldDisplayUpgradeSelectedRulesButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: selectedRulesButtonTooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: upgradeSelectedRules,
    disabled: !canUserEditRules || isRequestInProgress || doAllSelectedRulesHaveConflicts,
    "data-test-subj": "upgradeSelectedRulesButton"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.UPDATE_SELECTED_RULES(numberOfSelectedRules), isRuleUpgrading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : undefined)))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: allRulesButtonTooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    onClick: upgradeAllRules,
    disabled: !canUserEditRules || !hasRulesToUpgrade || isRequestInProgress,
    "data-test-subj": "upgradeAllRulesButton"
  }, i18n.UPDATE_ALL, isRuleUpgrading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : undefined))));
};
exports.UpgradePrebuiltRulesTableButtons = UpgradePrebuiltRulesTableButtons;
const useBulkUpdateButtonsTooltipContent = ({
  canUserEditRules,
  doAllSelectedRulesHaveConflicts,
  isPrebuiltRulesCustomizationEnabled
}) => {
  if (!canUserEditRules) {
    return {
      selectedRulesButtonTooltip: i18n.BULK_UPDATE_BUTTON_TOOLTIP_NO_PERMISSIONS,
      allRulesButtonTooltip: i18n.BULK_UPDATE_BUTTON_TOOLTIP_NO_PERMISSIONS
    };
  }
  if (!isPrebuiltRulesCustomizationEnabled) {
    return {
      selectedRulesButtonTooltip: undefined,
      allRulesButtonTooltip: undefined
    };
  }
  if (doAllSelectedRulesHaveConflicts) {
    return {
      selectedRulesButtonTooltip: i18n.BULK_UPDATE_SELECTED_RULES_BUTTON_TOOLTIP_CONFLICTS,
      allRulesButtonTooltip: undefined
    };
  }
  return {
    selectedRulesButtonTooltip: undefined,
    allRulesButtonTooltip: undefined
  };
};