"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleSearchField = RuleSearchField;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _rules_management_tour = require("../rules_table/guided_onboarding/rules_management_tour");
var i18n = _interopRequireWildcard(require("../../../../common/translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchBarWrapper = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  min-width: 200px;
  & .euiPopover {
    // This is needed to "cancel" styles passed down from EuiTourStep that
    // interfere with EuiFieldSearch and don't allow it to take the full width
    display: block;
  }
`;
function RuleSearchField({
  initialValue,
  onSearch,
  placeholder
}) {
  const [searchText, setSearchText] = (0, _react.useState)(initialValue);
  const handleChange = (0, _react.useCallback)(e => setSearchText(e.target.value), [setSearchText]);
  (0, _react.useEffect)(() => {
    setSearchText(initialValue);
  }, [initialValue]);
  return /*#__PURE__*/_react.default.createElement(SearchBarWrapper, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    id: _rules_management_tour.SEARCH_FIRST_RULE_ANCHOR,
    "aria-label": i18n.SEARCH_RULES,
    fullWidth: true,
    incremental: false,
    placeholder: placeholder !== null && placeholder !== void 0 ? placeholder : i18n.SEARCH_PLACEHOLDER,
    value: searchText,
    onChange: handleChange,
    onSearch: onSearch,
    "data-test-subj": "ruleSearchField"
  }));
}