"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddPrebuiltRulesTableNoItemsMessage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _common = require("../../../../../../common");
var _links = require("../../../../../common/components/links");
var i18n = _interopRequireWildcard(require("../../../../common/translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddPrebuiltRulesTableNoItemsMessageComponent = () => {
  const getSecuritySolutionLinkProps = (0, _links.useGetSecuritySolutionLinkProps)();
  const {
    onClick: onClickLink
  } = getSecuritySolutionLinkProps({
    deepLinkId: _common.SecurityPageName.rules
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    direction: "column",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, i18n.NO_RULES_AVAILABLE_FOR_INSTALL),
    titleSize: "s",
    body: i18n.NO_RULES_AVAILABLE_FOR_INSTALL_BODY,
    "data-test-subj": "noPrebuiltRulesAvailableForInstall"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "arrowLeft",
    color: 'primary',
    onClick: onClickLink,
    "data-test-subj": "addRulesGoBackToRulesTableBtn"
  }, i18n.GO_BACK_TO_RULES_TABLE_BUTTON)));
};
const AddPrebuiltRulesTableNoItemsMessage = exports.AddPrebuiltRulesTableNoItemsMessage = /*#__PURE__*/_react.default.memo(AddPrebuiltRulesTableNoItemsMessageComponent);