"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BackgroundImageCallout = BackgroundImageCallout;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function BackgroundImageCallout({
  description,
  backgroundImage,
  ...euiCalloutProps
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, (0, _extends2.default)({
    css: (0, _react2.css)`
        padding-left: ${euiTheme.size.xl};
        background-image: url(${backgroundImage});
        background-repeat: no-repeat;
        background-position-x: right;
        background-position-y: bottom;
      `
  }, euiCalloutProps), description);
}