"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MachineLearningRuleFieldReadOnly = MachineLearningRuleFieldReadOnly;
var _react = _interopRequireDefault(require("react"));
var _machine_learning_job_id = require("./fields/machine_learning_job_id/machine_learning_job_id");
var _type = require("./fields/type/type");
var _alert_suppression = require("./fields/alert_suppression/alert_suppression");
var _utility_types = require("../../../../../../../common/utility_types");
var _anomaly_threshold = require("./fields/anomaly_threshold/anomaly_threshold");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MachineLearningRuleFieldReadOnly({
  fieldName,
  finalDiffableRule
}) {
  switch (fieldName) {
    case 'anomaly_threshold':
      return /*#__PURE__*/_react.default.createElement(_anomaly_threshold.AnomalyThresholdReadOnly, {
        anomalyThreshold: finalDiffableRule.anomaly_threshold
      });
    case 'alert_suppression':
      return /*#__PURE__*/_react.default.createElement(_alert_suppression.AlertSuppressionReadOnly, {
        alertSuppression: finalDiffableRule.alert_suppression,
        ruleType: finalDiffableRule.type
      });
    case 'machine_learning_job_id':
      return /*#__PURE__*/_react.default.createElement(_machine_learning_job_id.MachineLearningJobIdReadOnly, {
        machineLearningJobId: finalDiffableRule.machine_learning_job_id
      });
    case 'type':
      return /*#__PURE__*/_react.default.createElement(_type.TypeReadOnly, {
        type: finalDiffableRule.type
      });
    default:
      return (0, _utility_types.assertUnreachable)(fieldName);
  }
}