"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FullRuleScheduleForm = FullRuleScheduleForm;
var _react = _interopRequireDefault(require("react"));
var _field_final_side = require("../../../field_final_side");
var _full_rule_schedule_adapter = require("./full_rule_schedule_adapter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FullRuleScheduleForm() {
  return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
    component: _full_rule_schedule_adapter.FullRuleScheduleAdapter,
    serializer: serializer,
    deserializer: deserializer
  });
}
function deserializer(_, finalRule) {
  return {
    interval: finalRule.rule_schedule.interval,
    from: finalRule.rule_schedule.from,
    to: finalRule.rule_schedule.to
  };
}
function serializer(formData) {
  return {
    rule_schedule: {
      interval: formData.interval,
      from: formData.from,
      to: formData.to
    }
  };
}