"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Subfield = void 0;
var _react = _interopRequireDefault(require("react"));
var _diff_view = require("../../json_diff/diff_view");
var _subfield_header = require("./subfield_header");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function shouldDisplaySubfieldLabelForField(fieldName) {
  return _constants.FIELDS_WITH_SUBFIELDS.includes(fieldName);
}
const Subfield = ({
  fieldName,
  subfieldName,
  oldSubfieldValue,
  newSubfieldValue
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, shouldDisplaySubfieldLabelForField(fieldName) && /*#__PURE__*/_react.default.createElement(_subfield_header.SubfieldHeader, {
  subfieldName: subfieldName
}), /*#__PURE__*/_react.default.createElement(_diff_view.DiffView, {
  oldSource: oldSubfieldValue,
  newSource: newSubfieldValue,
  viewType: "unified",
  "data-test-subj": "prebuilt-rule-upgrade-diff-view"
}));
exports.Subfield = Subfield;