"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesWithGapsOverviewPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/alerting-plugin/common");
var _rules_table_context = require("../../../rule_management_ui/components/rules_table/rules_table/rules_table_context");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_get_rule_ids_with_gaps = require("../../api/hooks/use_get_rule_ids_with_gaps");
var _constants = require("../../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulesWithGapsOverviewPanel = () => {
  const {
    state: {
      filterOptions: {
        gapSearchRange,
        showRulesWithGaps
      },
      lastUpdated: rulesTableLastUpdatedAt
    },
    actions: {
      setFilterOptions
    }
  } = (0, _rules_table_context.useRulesTableContext)();
  const {
    data: totalRulesWithGaps,
    refetch: refetchGetRuleIdsWithGaps
  } = (0, _use_get_rule_ids_with_gaps.useGetRuleIdsWithGaps)({
    gapRange: gapSearchRange !== null && gapSearchRange !== void 0 ? gapSearchRange : _constants.defaultRangeValue,
    statuses: [_common.gapStatus.UNFILLED, _common.gapStatus.PARTIALLY_FILLED]
  });
  const {
    data: inProgressRulesWithGaps,
    refetch: refetchGetRuleIdsWithGapsInProgressIntervals
  } = (0, _use_get_rule_ids_with_gaps.useGetRuleIdsWithGaps)({
    gapRange: gapSearchRange !== null && gapSearchRange !== void 0 ? gapSearchRange : _constants.defaultRangeValue,
    statuses: [_common.gapStatus.UNFILLED, _common.gapStatus.PARTIALLY_FILLED],
    hasInProgressIntervals: true
  });
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    refetchGetRuleIdsWithGaps();
    refetchGetRuleIdsWithGapsInProgressIntervals();
  }, [rulesTableLastUpdatedAt, refetchGetRuleIdsWithGaps, refetchGetRuleIdsWithGapsInProgressIntervals]);
  const rangeValueToLabel = {
    [_constants.GapRangeValue.LAST_24_H]: i18n.RULE_GAPS_OVERVIEW_PANEL_LAST_24_HOURS_LABEL,
    [_constants.GapRangeValue.LAST_3_D]: i18n.RULE_GAPS_OVERVIEW_PANEL_LAST_3_DAYS_LABEL,
    [_constants.GapRangeValue.LAST_7_D]: i18n.RULE_GAPS_OVERVIEW_PANEL_LAST_7_DAYS_LABEL
  };
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };
  const items = Object.values(_constants.GapRangeValue).map(value => ({
    value,
    label: rangeValueToLabel[value]
  }));
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "arrowDown",
    iconSide: "right",
    onClick: onButtonClick
  }, rangeValueToLabel[gapSearchRange !== null && gapSearchRange !== void 0 ? gapSearchRange : _constants.defaultRangeValue]);
  const handleShowRulesWithGapsFilterButtonClick = () => {
    setFilterOptions({
      showRulesWithGaps: !showRulesWithGaps
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "m",
    "data-test-subj": "rule-with-gaps_overview-panel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: 'rules_with_gaps_overview_panel',
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: item.value,
      onClick: () => {
        setFilterOptions({
          gapSearchRange: item.value
        });
        closePopover();
      }
    }, item.label))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("b", null, i18n.RULE_GAPS_OVERVIEW_PANEL_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, inProgressRulesWithGaps && totalRulesWithGaps && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: i18n.RULE_GAPS_OVERVIEW_PANEL_TOOLTIP_TEXT
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: (totalRulesWithGaps === null || totalRulesWithGaps === void 0 ? void 0 : totalRulesWithGaps.total) === 0 ? 'success' : 'warning'
  }, totalRulesWithGaps === null || totalRulesWithGaps === void 0 ? void 0 : totalRulesWithGaps.total, " ", '/', " ", inProgressRulesWithGaps === null || inProgressRulesWithGaps === void 0 ? void 0 : inProgressRulesWithGaps.total))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    isToggle: true,
    isSelected: showRulesWithGaps,
    hasActiveFilters: showRulesWithGaps,
    onClick: handleShowRulesWithGapsFilterButtonClick,
    iconType: showRulesWithGaps ? `checkInCircleFilled` : undefined
  }, i18n.RULE_GAPS_OVERVIEW_PANEL_SHOW_RULES_WITH_GAPS_LABEL)))));
};
exports.RulesWithGapsOverviewPanel = RulesWithGapsOverviewPanel;