"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.allExceptionItemsReducer = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const allExceptionItemsReducer = () => (state, action) => {
  switch (action.type) {
    case 'setExceptions':
      {
        var _pagination$total;
        const {
          exceptions,
          pagination
        } = action;
        return {
          ...state,
          pagination: {
            ...state.pagination,
            pageIndex: pagination.page - 1,
            pageSize: pagination.perPage,
            totalItemCount: (_pagination$total = pagination.total) !== null && _pagination$total !== void 0 ? _pagination$total : 0
          },
          exceptions
        };
      }
    case 'updateExceptionToEdit':
      {
        const {
          exception
        } = action;
        return {
          ...state,
          exceptionToEdit: exception
        };
      }
    case 'updateFlyoutOpen':
      {
        return {
          ...state,
          currenFlyout: action.flyoutType
        };
      }
    case 'setViewerState':
      {
        return {
          ...state,
          viewerState: action.state
        };
      }
    case 'setIsReadOnly':
      {
        return {
          ...state,
          isReadOnly: action.readOnly
        };
      }
    case 'setLastUpdateTime':
      {
        return {
          ...state,
          lastUpdated: action.lastUpdate
        };
      }
    case 'setExceptionsToShow':
      {
        const newExceptionsToShow = {
          ...state.exceptionsToShow,
          ...{
            [action.optionId]: !state.exceptionsToShow[action.optionId]
          }
        };

        // At least one button must be selected
        if (!newExceptionsToShow.active && !newExceptionsToShow.expired) {
          return {
            ...state,
            exceptionsToShow: {
              active: true
            }
          };
        }
        return {
          ...state,
          exceptionsToShow: newExceptionsToShow
        };
      }
    default:
      return state;
  }
};
exports.allExceptionItemsReducer = allExceptionItemsReducer;