"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEsqlFields = exports.useAllEsqlRuleFields = void 0;
var _react = require("react");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _esql_query_columns = require("../../rule_creation/logic/esql_query_columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const esqlToFields = columns => {
  const fields = columns.map(({
    id,
    meta
  }) => ({
    name: id,
    type: meta.type
  }));
  return fields;
};
/**
 * fetches ES|QL fields and convert them to DataViewBase fields
 */
const useEsqlFields = esqlQuery => {
  const {
    columns,
    isLoading
  } = (0, _esql_query_columns.useEsqlQueryColumns)(esqlQuery !== null && esqlQuery !== void 0 ? esqlQuery : '');
  const fields = (0, _react.useMemo)(() => {
    return esqlToFields(columns);
  }, [columns]);
  return {
    fields,
    isLoading
  };
};

/**
 * if ES|QL fields and index pattern fields have same name, duplicates will be removed and the rest of fields merged
 * ES|QL fields are first in order, since these are the fields that returned in ES|QL response
 * */
exports.useEsqlFields = useEsqlFields;
const deduplicateAndMergeFields = (esqlFields, indexPatternsFields) => {
  const esqlFieldsSet = new Set(esqlFields.map(field => field.name));
  return [...esqlFields, ...indexPatternsFields.filter(field => !esqlFieldsSet.has(field.name))];
};
/**
 * returns all fields available for ES|QL rule:
 * - fields returned from ES|QL query for aggregating queries
 * - fields returned from ES|QL query + index fields for non-aggregating queries
 */
const useAllEsqlRuleFields = ({
  esqlQuery,
  indexPatternsFields
}) => {
  const [debouncedEsqlQuery, setDebouncedEsqlQuery] = (0, _react.useState)(undefined);
  const {
    fields: esqlFields,
    isLoading
  } = useEsqlFields(debouncedEsqlQuery);
  const isEsqlQueryAggregating = (0, _react.useMemo)(() => (0, _securitysolutionUtils.computeIsESQLQueryAggregating)(debouncedEsqlQuery !== null && debouncedEsqlQuery !== void 0 ? debouncedEsqlQuery : ''), [debouncedEsqlQuery]);
  (0, _useDebounce.default)(() => {
    setDebouncedEsqlQuery(esqlQuery);
  }, 300, [esqlQuery]);
  const fields = (0, _react.useMemo)(() => {
    if (!debouncedEsqlQuery) {
      return indexPatternsFields;
    }
    return isEsqlQueryAggregating ? esqlFields : deduplicateAndMergeFields(esqlFields, indexPatternsFields);
  }, [esqlFields, debouncedEsqlQuery, indexPatternsFields, isEsqlQueryAggregating]);
  return {
    fields,
    isLoading
  };
};
exports.useAllEsqlRuleFields = useAllEsqlRuleFields;