"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityOverride = SeverityOverride;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionAutocomplete = require("@kbn/securitysolution-autocomplete");
var _data = require("../step_about_rule/data");
var _kibana = require("../../../../common/lib/kibana");
var styles = _interopRequireWildcard(require("./styles"));
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SeverityOverride({
  isDisabled,
  onSeverityMappingChecked,
  onFieldChange,
  onFieldMatchValueChange,
  isMappingChecked,
  dataTestSubj = 'severity',
  idAria,
  mapping,
  indices
}) {
  const severityMappingLabel = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      onClick: isDisabled ? undefined : onSeverityMappingChecked
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: "severity-mapping-override",
      checked: isMappingChecked,
      disabled: isDisabled,
      onChange: onSeverityMappingChecked
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, i18n.SEVERITY_MAPPING)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(NestedContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, i18n.SEVERITY_MAPPING_DESCRIPTION)));
  }, [onSeverityMappingChecked, isDisabled, isMappingChecked]);
  const describedByIds = (0, _react.useMemo)(() => idAria ? [idAria] : undefined, [idAria]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: severityMappingLabel,
    helpText: isMappingChecked ? /*#__PURE__*/_react.default.createElement(NestedContent, null, i18n.SEVERITY_MAPPING_DETAILS) : '',
    fullWidth: true,
    "data-test-subj": `${dataTestSubj}-severityOverride`,
    describedByIds: describedByIds
  }, /*#__PURE__*/_react.default.createElement(NestedContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), isMappingChecked && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(EuiFlexItemComboBoxColumn, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, i18n.SOURCE_FIELD)), /*#__PURE__*/_react.default.createElement(EuiFlexItemComboBoxColumn, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, i18n.SOURCE_VALUE)), /*#__PURE__*/_react.default.createElement(EuiFlexItemIconColumn, null), /*#__PURE__*/_react.default.createElement(EuiFlexItemSeverityColumn, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, i18n.DEFAULT_SEVERITY)))), mapping.map((severityMappingItem, index) => /*#__PURE__*/_react.default.createElement(SeverityMappingRow, {
    key: index,
    severityMappingItem: severityMappingItem,
    index: index,
    indices: indices,
    isDisabled: isDisabled,
    onFieldChange: onFieldChange,
    onFieldMatchValueChange: onFieldMatchValueChange
  })))));
}
function SeverityMappingRow({
  severityMappingItem,
  index,
  indices,
  isDisabled,
  onFieldChange,
  onFieldMatchValueChange
}) {
  var _severityOptions$find;
  const {
    services
  } = (0, _kibana.useKibana)();
  const handleFieldChange = (0, _react.useCallback)(newField => {
    onFieldChange(index, severityMappingItem.severity, newField);
  }, [index, severityMappingItem.severity, onFieldChange]);
  const handleFieldMatchValueChange = (0, _react.useCallback)(newMatchValue => {
    onFieldMatchValueChange(index, severityMappingItem.severity, newMatchValue);
  }, [index, severityMappingItem.severity, onFieldMatchValueChange]);
  const severityOptions = (0, _data.useSeverityOptions)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `${severityMappingItem.severity}-${index}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "severityOverrideRow",
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(EuiFlexItemComboBoxColumn, null, /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.EsFieldSelector, {
    placeholder: "",
    selectedField: getFieldTypeByMapping(severityMappingItem, indices),
    isDisabled: isDisabled,
    indexPattern: indices,
    onChange: handleFieldChange,
    "aria-label": i18n.SOURCE_FIELD
  })), /*#__PURE__*/_react.default.createElement(EuiFlexItemComboBoxColumn, null, /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.AutocompleteFieldMatchComponent, {
    autocompleteService: services.unifiedSearch.autocomplete,
    placeholder: "",
    selectedField: getFieldTypeByMapping(severityMappingItem, indices),
    selectedValue: severityMappingItem.value,
    isClearable: true,
    isDisabled: isDisabled,
    indexPattern: indices,
    onChange: handleFieldMatchValueChange,
    "aria-label": i18n.SOURCE_VALUE
  })), /*#__PURE__*/_react.default.createElement(EuiFlexItemIconColumn, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortRight"
  })), /*#__PURE__*/_react.default.createElement(EuiFlexItemSeverityColumn, null, (_severityOptions$find = severityOptions.find(o => o.value === severityMappingItem.severity)) === null || _severityOptions$find === void 0 ? void 0 : _severityOptions$find.inputDisplay)));
}
const NestedContent = ({
  children
}) => /*#__PURE__*/_react.default.createElement("div", {
  className: styles.nestedContent
}, children);
const EuiFlexItemComboBoxColumn = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  className: styles.comboBoxColumn
}, children);
const EuiFlexItemIconColumn = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  className: styles.iconColumn,
  grow: false
}, children);
const EuiFlexItemSeverityColumn = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  className: styles.severityColumn,
  grow: false
}, children);

/**
 * Looks for field metadata (DataViewFieldBase) in existing index pattern.
 * If specified field doesn't exist, returns a stub DataViewFieldBase created based on the mapping --
 * because the field might not have been indexed yet, but we still need to display the mapping.
 *
 * @param mapping Mapping of a specified field name + value to a certain severity value.
 * @param pattern Existing index pattern.
 */
const getFieldTypeByMapping = (mapping, pattern) => {
  const {
    field
  } = mapping;
  const [knownFieldType] = pattern.fields.filter(({
    name
  }) => field === name);
  return knownFieldType !== null && knownFieldType !== void 0 ? knownFieldType : {
    name: field,
    type: 'string'
  };
};