"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isNoisy = exports.getTimeframeOptions = exports.getIsRulePreviewDisabled = void 0;
var _lodash = require("lodash");
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("../../../common/types");
var _constants = require("../../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Determines whether or not to display noise warning.
 * Is considered noisy if alerts/hour rate > 1
 * @param hits Total query search hits
 * @param timeframe Range selected by user (last hour, day...)
 */
const isNoisy = (hits, timeframe) => {
  const oneHour = 1000 * 60 * 60;
  const durationInHours = Math.max((timeframe.timeframeEnd.valueOf() - timeframe.timeframeStart.valueOf()) / oneHour, 1.0);
  return hits / durationInHours > 1;
};

/**
 * Determines what timerange options to show.
 * Eql sequence queries tend to be slower, so decided
 * not to include the last month option.
 * @param ruleType
 */
exports.isNoisy = isNoisy;
const getTimeframeOptions = ruleType => {
  if (ruleType === 'eql') {
    return [{
      value: 'h',
      text: i18n.LAST_HOUR
    }, {
      value: 'd',
      text: i18n.LAST_DAY
    }];
  } else if (ruleType === 'threat_match') {
    return [{
      value: 'h',
      text: i18n.LAST_HOUR
    }, {
      value: 'd',
      text: i18n.LAST_DAY
    }, {
      value: 'w',
      text: i18n.LAST_WEEK
    }];
  } else if (ruleType === 'threshold') {
    return [{
      value: 'h',
      text: i18n.LAST_HOUR
    }];
  } else {
    return [{
      value: 'h',
      text: i18n.LAST_HOUR
    }, {
      value: 'd',
      text: i18n.LAST_DAY
    }, {
      value: 'M',
      text: i18n.LAST_MONTH
    }];
  }
};
exports.getTimeframeOptions = getTimeframeOptions;
const isNewTermsPreviewDisabled = newTermsFields => {
  return newTermsFields.length === 0 || newTermsFields.length > _constants.MAX_NUMBER_OF_NEW_TERMS_FIELDS;
};
const isEsqlPreviewDisabled = ({
  isQueryBarValid,
  queryBar
}) => {
  return !isQueryBarValid || (0, _lodash.isEmpty)(queryBar.query.query);
};
const isThreatMatchPreviewDisabled = ({
  isThreatQueryBarValid,
  threatIndex,
  threatMapping
}) => {
  var _threatMapping$0$entr;
  if (!isThreatQueryBarValid || !threatIndex.length || !threatMapping) {
    return true;
  } else if (!threatMapping.length || !((_threatMapping$0$entr = threatMapping[0].entries) !== null && _threatMapping$0$entr !== void 0 && _threatMapping$0$entr.length) || !threatMapping[0].entries[0].field || !threatMapping[0].entries[0].value) {
    return true;
  }
  return false;
};
const getIsRulePreviewDisabled = ({
  ruleType,
  isQueryBarValid,
  isThreatQueryBarValid,
  index,
  dataViewId,
  dataSourceType,
  threatIndex,
  threatMapping,
  machineLearningJobId,
  queryBar,
  newTermsFields = []
}) => {
  if (ruleType === 'esql') {
    return isEsqlPreviewDisabled({
      isQueryBarValid,
      queryBar
    });
  }
  if (ruleType === 'machine_learning') {
    var _machineLearningJobId;
    // @ts-expect-error upgrade typescript v5.9.3
    return (_machineLearningJobId = !machineLearningJobId) !== null && _machineLearningJobId !== void 0 ? _machineLearningJobId : (machineLearningJobId === null || machineLearningJobId === void 0 ? void 0 : machineLearningJobId.length) === 0;
  }
  if (!isQueryBarValid || dataSourceType === _types.DataSourceType.DataView && !dataViewId || dataSourceType === _types.DataSourceType.IndexPatterns && index.length === 0) {
    return true;
  }
  if (ruleType === 'threat_match') {
    return isThreatMatchPreviewDisabled({
      threatIndex,
      threatMapping,
      isThreatQueryBarValid
    });
  }
  if (ruleType === 'eql') {
    return (0, _lodash.isEmpty)(queryBar.query.query);
  }
  if (ruleType === 'query' || ruleType === 'threshold') {
    return (0, _lodash.isEmpty)(queryBar.query.query) && (0, _lodash.isEmpty)(queryBar.filters);
  }
  if (ruleType === 'new_terms') {
    return isNewTermsPreviewDisabled(newTermsFields);
  }
  return false;
};
exports.getIsRulePreviewDisabled = getIsRulePreviewDisabled;