"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultRiskScore = DefaultRiskScore;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _default_risk_score_validator = require("../../validators/default_risk_score_validator");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DefaultRiskScore({
  value,
  onChange,
  errorMessage,
  idAria,
  dataTestSubj = 'defaultRiskScore'
}) {
  const handleChange = (0, _react.useCallback)(event => {
    const eventValue = event.target.value;
    const intOrNanValue = Number.parseInt(eventValue.trim(), 10);
    const intValue = Number.isNaN(intOrNanValue) ? _default_risk_score_validator.MIN_RISK_SCORE : intOrNanValue;
    onChange(intValue);
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(DefaultRiskScoreLabel, null),
    error: errorMessage,
    isInvalid: !!errorMessage,
    fullWidth: true,
    "data-test-subj": `${dataTestSubj}-defaultRisk`,
    describedByIds: idAria ? [idAria] : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    value: value,
    onChange: handleChange,
    max: _default_risk_score_validator.MAX_RISK_SCORE,
    min: _default_risk_score_validator.MIN_RISK_SCORE,
    showRange: true,
    showInput: true,
    fullWidth: false,
    showTicks: true,
    tickInterval: 25,
    "data-test-subj": `${dataTestSubj}-defaultRiskRange`
  })));
}
function DefaultRiskScoreLabel() {
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, i18n.DEFAULT_RISK_SCORE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs'
  }, i18n.RISK_SCORE_DESCRIPTION));
}