"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.THRESHOLD_VALUE_CONFIG = exports.THRESHOLD_FIELD_CONFIG = void 0;
exports.getCardinalityFieldConfig = getCardinalityFieldConfig;
exports.getCardinalityValueConfig = getCardinalityValueConfig;
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _lodash = require("lodash");
var _shared_imports = require("../../../../shared_imports");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const THRESHOLD_FIELD_CONFIG = exports.THRESHOLD_FIELD_CONFIG = {
  type: _hook_form_lib.FIELD_TYPES.COMBO_BOX,
  label: i18n.THRESHOLD_FIELD_LABEL,
  helpText: i18n.THRESHOLD_FIELD_HELP_TEXT,
  validations: [{
    validator: _shared_imports.fieldValidators.maxLengthField({
      length: 3,
      message: i18n.THRESHOLD_FIELD_COUNT_VALIDATION_ERROR
    })
  }]
};
const THRESHOLD_VALUE_CONFIG = exports.THRESHOLD_VALUE_CONFIG = {
  type: _hook_form_lib.FIELD_TYPES.NUMBER,
  label: i18n.THRESHOLD_VALUE_LABEL,
  validations: [{
    validator: _shared_imports.fieldValidators.numberGreaterThanField({
      than: 1,
      message: i18n.THRESHOLD_VALUE_VALIDATION_ERROR,
      allowEquality: true
    })
  }]
};
function getCardinalityFieldConfig(path) {
  return {
    defaultValue: [],
    fieldsToValidateOnChange: [`${path}.cardinality.field`, `${path}.cardinality.value`],
    type: _hook_form_lib.FIELD_TYPES.COMBO_BOX,
    label: i18n.CARDINALITY_FIELD_LABEL,
    validations: [{
      validator: (...args) => {
        const [{
          formData
        }] = args;
        if (!(0, _lodash.isEmpty)(formData[`${path}.cardinality.value`])) {
          return _shared_imports.fieldValidators.emptyField(i18n.CARDINALITY_FIELD_MISSING_VALIDATION_ERROR)(...args);
        }
      }
    }],
    helpText: i18n.CARDINALITY_FIELD_HELP_TEXT
  };
}
function getCardinalityValueConfig(path) {
  return {
    fieldsToValidateOnChange: [`${path}.cardinality.field`, `${path}.cardinality.value`],
    type: _hook_form_lib.FIELD_TYPES.NUMBER,
    label: i18n.CARDINALITY_VALUE_LABEL,
    validations: [{
      validator: (...args) => {
        const [{
          formData
        }] = args;
        if (!(0, _lodash.isEmpty)(formData[`${path}.cardinality.field`])) {
          return _shared_imports.fieldValidators.numberGreaterThanField({
            than: 1,
            message: i18n.CARDINALITY_VALUE_VALIDATION_ERROR,
            allowEquality: true
          })(...args);
        }
      }
    }]
  };
}