"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_THREAT_MAPPING_VALUE = void 0;
exports.ThreatMatchMappingField = ThreatMatchMappingField;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _helpers = require("../../../../common/components/threat_match/helpers");
var _threat_match = require("../../../../common/components/threat_match");
var _shared_imports = require("../../../../shared_imports");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_THREAT_MAPPING_VALUE = exports.DEFAULT_THREAT_MAPPING_VALUE = [(0, _helpers.createOrNewEntryItem)()];
function ThreatMatchMappingField({
  field,
  indexPatterns,
  threatIndexPatterns
}) {
  const {
    isInvalid,
    errorMessage
  } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
  const {
    setValue,
    validate
  } = field;
  const prevIndexTitle = (0, _usePrevious.default)(indexPatterns.title);
  const prevThreatTitle = (0, _usePrevious.default)(threatIndexPatterns.title);

  // We have to make sure validation runs against the latest source events index patterns
  // and threat match index patterns.
  // Form lib's `fieldsToValidateOnChange` on the corresponding index patterns edit fields
  // doesn't help here. It leads to running threat match mapping validation before render
  // of this component happens. In the end validation runs against previous index patterns
  // producing invalid validation results.
  //
  // Validating the field imperatively here fixes this issue.
  (0, _react.useEffect)(() => {
    if (indexPatterns.title === prevIndexTitle && threatIndexPatterns.title === prevThreatTitle) {
      return;
    }
    validate();
  }, [indexPatterns.title, threatIndexPatterns.title, prevIndexTitle, prevThreatTitle, validate]);
  const handleMappingChange = (0, _react.useCallback)(entryItems => {
    if (entryItems.length === 0) {
      setValue(DEFAULT_THREAT_MAPPING_VALUE);
      return;
    }
    setValue(entryItems);
  }, [setValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: field.label,
    labelAppend: field.labelAppend,
    helpText: field.helpText,
    error: errorMessage,
    isInvalid: isInvalid,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_threat_match.ThreatMatchComponent, {
    mappingEntries: field.value,
    indexPatterns: indexPatterns,
    threatIndexPatterns: threatIndexPatterns,
    "data-test-subj": "ruleThreatMatchMappingField",
    "id-aria": "ruleThreatMatchMappingField",
    onMappingEntriesChange: handleMappingChange
  }));
}