"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stepActionsDefaultValue = exports.StepRuleActionsReadOnly = exports.StepRuleActions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _rule_actions_field = require("../../../../common/components/rule_actions_field");
var _response_actions_form = require("../../../rule_response_actions/response_actions_form");
var _shared_imports = require("../../../../shared_imports");
var _step_content_wrapper = require("../step_content_wrapper");
var _kibana = require("../../../../common/lib/kibana");
var _use_fetch_connectors_query = require("../../../rule_management/api/hooks/use_fetch_connectors_query");
var _use_fetch_connector_types_query = require("../../../rule_management/api/hooks/use_fetch_connector_types_query");
var i18n = _interopRequireWildcard(require("./translations"));
var _rule_snooze_section = require("./rule_snooze_section");
var _notification_action = require("./notification_action");
var _response_action = require("./response_action");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stepActionsDefaultValue = exports.stepActionsDefaultValue = {
  enabled: true,
  actions: [],
  responseActions: [],
  kibanaSiemAppUrl: ''
};
const GhostFormField = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
const DisplayActionsHeader = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Actions",
    id: "xpack.securitySolution.detectionEngine.rule.editRule.actionSectionsTitle"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
};
const StepRuleActionsComponent = ({
  ruleId,
  ruleTypeId,
  isUpdateView = false,
  actionMessageParams,
  summaryActionMessageParams,
  form
}) => {
  const {
    services: {
      application
    }
  } = (0, _kibana.useKibana)();
  const displayActionsOptions = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "actions",
    component: _rule_actions_field.RuleActionsField,
    componentProps: {
      messageVariables: actionMessageParams,
      summaryMessageVariables: summaryActionMessageParams,
      ruleTypeId
    }
  })), [actionMessageParams, ruleTypeId, summaryActionMessageParams]);
  const displayResponseActionsOptions = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseArray, {
      path: "responseActions",
      initialNumberOfItems: 0
    }, _response_actions_form.ResponseActionsForm);
  }, []);
  // only display the actions dropdown if the user has "read" privileges for actions
  const displayActionsDropDown = (0, _react.useMemo)(() => {
    return application.capabilities.actions.show ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(DisplayActionsHeader, null), ruleId && /*#__PURE__*/_react.default.createElement(_rule_snooze_section.RuleSnoozeSection, {
      ruleId: ruleId
    }), displayActionsOptions, displayResponseActionsOptions, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      path: "kibanaSiemAppUrl",
      component: GhostFormField
    }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      path: "enabled",
      component: GhostFormField
    })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, i18n.NO_ACTIONS_READ_PERMISSIONS));
  }, [ruleId, application.capabilities.actions.show, displayActionsOptions, displayResponseActionsOptions]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    addPadding: !isUpdateView
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "stepRuleActions"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, displayActionsDropDown))));
};
const StepRuleActions = exports.StepRuleActions = /*#__PURE__*/(0, _react.memo)(StepRuleActionsComponent);
const StepRuleActionsReadOnlyComponent = ({
  addPadding,
  defaultValues: ruleActionsData
}) => {
  const {
    services: {
      triggersActionsUi
    }
  } = (0, _kibana.useKibana)();
  const actionTypeRegistry = triggersActionsUi.actionTypeRegistry;
  const {
    data: connectors
  } = (0, _use_fetch_connectors_query.useFetchConnectorsQuery)();
  const {
    data: connectorTypes
  } = (0, _use_fetch_connector_types_query.useFetchConnectorTypesQuery)();
  const notificationActions = ruleActionsData.actions;
  const responseActions = ruleActionsData.responseActions || [];
  const ruleHasActions = notificationActions.length > 0 || responseActions.length > 0;
  if (!ruleHasActions || !connectors || !connectorTypes) {
    return null;
  }
  const hasBothNotificationAndResponseActions = notificationActions.length > 0 && responseActions.length > 0;
  return /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    addPadding: addPadding
  }, notificationActions.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, i18n.NOTIFICATION_ACTIONS), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), notificationActions.map((action, index) => {
    const isLastItem = index === notificationActions.length - 1;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_notification_action.NotificationAction, {
      action: action,
      connectorTypes: connectorTypes,
      connectors: connectors,
      actionTypeRegistry: actionTypeRegistry,
      key: action.id
    }), !isLastItem && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }), hasBothNotificationAndResponseActions && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), responseActions.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, i18n.RESPONSE_ACTIONS), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), responseActions.map((action, index) => {
    const isLastItem = index === responseActions.length - 1;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_response_action.ResponseAction, {
      action: action,
      key: `${action.actionTypeId}-${index}`
    }), !isLastItem && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }));
};
const StepRuleActionsReadOnly = exports.StepRuleActionsReadOnly = /*#__PURE__*/(0, _react.memo)(StepRuleActionsReadOnlyComponent);