"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/dashboard-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _spy_routes = require("../../../common/utils/route/spy_routes");
var _kibana = require("../../../common/lib/kibana");
var _use_dashboard_view_prompt_state = require("../../hooks/use_dashboard_view_prompt_state");
var _dashboard_renderer = require("../../components/dashboard_renderer");
var _status_prompt = require("../../components/status_prompt");
var _search_bar = require("../../../common/components/search_bar");
var _page_wrapper = require("../../../common/components/page_wrapper");
var _filters_global = require("../../../common/components/filters_global");
var _constants2 = require("../../../common/store/inputs/constants");
var _containers = require("../../../sourcerer/containers");
var _header_page = require("../../../common/components/header_page");
var _store = require("../../../common/store");
var _use_selector = require("../../../common/hooks/use_selector");
var _dashboard_tool_bar = require("../../components/dashboard_tool_bar");
var _use_dashboard_renderer = require("../../hooks/use_dashboard_renderer");
var _dashboard_title = require("../../components/dashboard_title");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dashboardViewFlexGroupStyle = {
  minHeight: `calc(100vh - 140px)`
};
const DashboardViewComponent = ({
  initialViewMode
}) => {
  const {
    fromStr,
    toStr,
    from,
    to
  } = (0, _use_selector.useDeepEqualSelector)(state => (0, _fp.pick)(['fromStr', 'toStr', 'from', 'to'], _store.inputsSelectors.globalTimeRangeSelector(state)));
  const timeRange = (0, _react.useMemo)(() => ({
    from,
    to,
    fromStr,
    toStr
  }), [from, fromStr, to, toStr]);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const filters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const {
    sourcererDataView: oldSourcererDataView
  } = (0, _containers.useSourcererDataView)();
  const {
    show: canReadDashboard
  } = (0, _kibana.useCapabilities)(_public.LEGACY_DASHBOARD_APP_ID);
  const errorState = (0, _react.useMemo)(() => canReadDashboard ? null : _use_dashboard_view_prompt_state.DashboardViewPromptState.NoReadPermission, [canReadDashboard]);
  const [viewMode, setViewMode] = (0, _react.useState)(initialViewMode);
  const {
    detailName: savedObjectId
  } = (0, _reactRouterDom.useParams)();
  const [dashboardTitle, setDashboardTitle] = (0, _react.useState)();
  const {
    dashboardContainer,
    handleDashboardLoaded
  } = (0, _use_dashboard_renderer.useDashboardRenderer)();
  const onDashboardToolBarLoad = (0, _react.useCallback)(mode => {
    setViewMode(mode);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, null, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    id: _constants2.InputsModelId.global,
    sourcererDataView: oldSourcererDataView // TODO: newDataViewPickerEnabled -  Can be removed when the new data view picker is released
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    style: dashboardViewFlexGroupStyle,
    gutterSize: "none",
    "data-test-subj": "dashboard-view-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, dashboardContainer && /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    border: true,
    title: /*#__PURE__*/_react.default.createElement(_dashboard_title.DashboardTitle, {
      dashboardContainer: dashboardContainer,
      onTitleLoaded: setDashboardTitle
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_dashboard_tool_bar.DashboardToolBar, {
      dashboardContainer: dashboardContainer,
      onLoad: onDashboardToolBarLoad
    })
  })), !errorState && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_dashboard_renderer.DashboardRenderer, {
    query: query,
    filters: filters,
    canReadDashboard: canReadDashboard,
    dashboardContainer: dashboardContainer,
    id: `dashboard-view-${savedObjectId}`,
    onDashboardContainerLoaded: handleDashboardLoaded,
    savedObjectId: savedObjectId,
    timeRange: timeRange,
    viewMode: viewMode
  })), errorState && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "dashboard-view-error-prompt-wrapper",
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_status_prompt.StatusPrompt, {
    currentState: errorState
  })), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _constants.SecurityPageName.dashboards,
    state: {
      dashboardName: dashboardTitle
    }
  }))));
};
DashboardViewComponent.displayName = 'DashboardViewComponent';
const DashboardView = exports.DashboardView = /*#__PURE__*/_react.default.memo(DashboardViewComponent);