"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esqlResponseToRecords = esqlResponseToRecords;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Function copied from elasticsearch-8.x/lib/helpers
function esqlResponseToRecords(response) {
  if (!response) return [];
  const {
    columns,
    values
  } = response;
  return values.map(row => {
    const doc = {};
    row.forEach((cell, index) => {
      const {
        name
      } = columns[index];
      doc[name] = cell;
    });
    return doc;
  });
}