"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFleetContextReduxStore = void 0;
var _redux = require("redux");
var _reducer = require("../../../management/store/reducer");
var _app = require("../../store/app");
var _experimental_features_service = require("../../experimental_features_service");
var _middleware = require("../../../management/store/middleware");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const composeEnhancers = window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ || _redux.compose;
const createFleetContextReduxStore = ({
  coreStart,
  depsStart,
  reducersObject = {
    management: _reducer.managementReducer,
    app: _app.appReducer
  },
  preloadedState = {
    // @ts-expect-error TS2322
    management: undefined,
    // @ts-expect-error TS2322
    app: {
      enableExperimental: _experimental_features_service.ExperimentalFeaturesService.get()
    }
  },
  additionalMiddleware = []
}) => {
  // Most of the code here was copied form
  // x-pack/solutions/security/plugins/security_solution/public/management/index.ts
  return (0, _redux.createStore)((0, _redux.combineReducers)(reducersObject), preloadedState, composeEnhancers((0, _redux.applyMiddleware)(...(0, _middleware.managementMiddlewareFactory)(coreStart, depsStart), ...additionalMiddleware)));
};
exports.createFleetContextReduxStore = createFleetContextReduxStore;