"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHiddenByFlyout = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _tour_config = require("./tour_config");
var _kibana = require("../../lib/kibana");
var _use_url_state = require("../../hooks/use_url_state");
var _helpers = require("../../utils/global_query_string/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 ** To check if given Guided tour step should be hidden when the LEFT expandable flyout
 ** or any case modal is opened
 */
const useHiddenByFlyout = ({
  tourId,
  step
}) => {
  const {
    useIsAddToCaseOpen
  } = (0, _kibana.useKibana)().services.cases.hooks;
  const isAddToCaseOpen = useIsAddToCaseOpen();
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const expandableFlyoutKey = (0, _react.useMemo)(() => (0, _helpers.getObjectFromQueryString)(_use_url_state.URL_PARAM_KEY.flyout, search), [search]);
  const isExpandableFlyoutExpanded = expandableFlyoutKey === null || expandableFlyoutKey === void 0 ? void 0 : expandableFlyoutKey.left;
  const hiddenWhenExpandableFlyoutOpened = (0, _react.useMemo)(() => {
    var _hiddenWhenLeftExpand;
    return isExpandableFlyoutExpanded && ((_hiddenWhenLeftExpand = _tour_config.hiddenWhenLeftExpandableFlyoutExpanded[_tour_config.SecurityStepId.alertsCases]) === null || _hiddenWhenLeftExpand === void 0 ? void 0 : _hiddenWhenLeftExpand.includes(step));
  }, [isExpandableFlyoutExpanded, step]);
  const hiddenWhenCasesModalFlyoutExpanded = (0, _react.useMemo)(() => {
    var _hiddenWhenCaseFlyout;
    return isAddToCaseOpen && ((_hiddenWhenCaseFlyout = _tour_config.hiddenWhenCaseFlyoutExpanded[tourId]) === null || _hiddenWhenCaseFlyout === void 0 ? void 0 : _hiddenWhenCaseFlyout.includes(step));
  }, [isAddToCaseOpen, tourId, step]);
  return hiddenWhenExpandableFlyoutOpened || hiddenWhenCasesModalFlyoutExpanded;
};
exports.useHiddenByFlyout = useHiddenByFlyout;