"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FiltersGlobal = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactReversePortal = require("react-reverse-portal");
var _eui = require("@elastic/eui");
var _use_global_header_portal = require("../../hooks/use_global_header_portal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FiltersGlobalContainer = _styledComponents.default.header`
  display: ${({
  show
}) => show ? 'block' : 'none'};
`;
FiltersGlobalContainer.displayName = 'FiltersGlobalContainer';
const FiltersGlobal = exports.FiltersGlobal = /*#__PURE__*/_react.default.memo(({
  children,
  show = true
}) => {
  const {
    globalKQLHeaderPortalNode
  } = (0, _use_global_header_portal.useGlobalHeaderPortal)();
  return /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: globalKQLHeaderPortalNode
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    color: "subdued",
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(FiltersGlobalContainer, {
    "data-test-subj": "filters-global-container",
    show: show
  }, children)));
});
FiltersGlobal.displayName = 'FiltersGlobal';