"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCombinedFilterQuery = void 0;
var _kuery = require("../../lib/kuery");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCombinedFilterQuery = ({
  from,
  to,
  filters,
  ...combineQueriesParams
}) => {
  const combinedQueries = (0, _kuery.combineQueries)({
    ...combineQueriesParams,
    filters: [...filters, (0, _kuery.buildTimeRangeFilter)(from, to)]
  });
  return combinedQueries ? combinedQueries.filterQuery : undefined;
};
exports.getCombinedFilterQuery = getCombinedFilterQuery;