"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DroppableWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _polished = require("polished");
var _react = _interopRequireWildcard(require("react"));
var _dnd = require("@hello-pangea/dnd");
var _styledComponents = _interopRequireDefault(require("styled-components"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReactDndDropTarget = _styledComponents.default.div`
  transition: background-color 0.7s ease;
  width: 100%;
  height: ${({
  height
}) => height};

  .flyout-overlay {
    .euiPanel {
      background-color: ${props => props.theme.eui.euiFormBackgroundColor};
    }
  }

  ${props => props.isDraggingOver ? `
    .drop-and-provider-timeline {
      &:hover {
        background-color: ${(0, _polished.rgba)(props.theme.eui.euiColorSuccess, 0.3)};
      }
    }
    .drop-and-provider-timeline:hover {
        background-color: ${(0, _polished.rgba)(props.theme.eui.euiColorSuccess, 0.3)};
    }
  > div.timeline-drop-area-empty {
     color: ${props.theme.eui.euiColorSuccess};
     background-color: ${(0, _polished.rgba)(props.theme.eui.euiColorSuccess, 0.2)};

     & .timeline-drop-area-empty__text {
      color: ${props.theme.eui.euiColorSuccess};
     }
  }
  > div.timeline-drop-area {
    background-color: ${(0, _polished.rgba)(props.theme.eui.euiColorSuccess, 0.2)};
    .provider-item-filter-container div:first-child{
      /* Override dragNdrop beautiful so we do not have our droppable moving around for no good reason */
      transform: none !important;
    }
    .drop-and-provider-timeline {
      display: block !important;
      + div {
        display: none;
      }
    }

    & .euiFormHelpText {
      color: ${props.theme.eui.euiColorSuccess};
    }
  }
  .flyout-overlay {
    .euiPanel {
      background-color: ${props.theme.eui.euiColorLightShade};
    }
    + div {
      /* Override dragNdrop beautiful so we do not have our droppable moving around for no good reason */
      display: none !important;
    }
  }
  ` : ''}
  > div.timeline-drop-area {
    .drop-and-provider-timeline {
      display: none;
    }

    & + div {
      /* Override dragNdrop beautiful so we do not have our droppable moving around for no good reason */
      display: none !important;
    }
  }
`;
ReactDndDropTarget.displayName = 'ReactDndDropTarget';
const DroppableWrapper = exports.DroppableWrapper = /*#__PURE__*/_react.default.memo(({
  children = null,
  droppableId,
  height = '100%',
  type,
  render = null,
  renderClone
}) => {
  const DroppableContent = (0, _react.useCallback)((provided, snapshot) => /*#__PURE__*/_react.default.createElement(ReactDndDropTarget, (0, _extends2.default)({
    height: height,
    ref: provided.innerRef
  }, provided.droppableProps, {
    isDraggingOver: snapshot.isDraggingOver
  }), render == null ? children : render({
    isDraggingOver: snapshot.isDraggingOver
  }), provided.placeholder), [children, height, render]);
  return /*#__PURE__*/_react.default.createElement(_dnd.Droppable, {
    droppableId: droppableId,
    direction: 'horizontal',
    type: type,
    renderClone: renderClone
  }, DroppableContent);
});
DroppableWrapper.displayName = 'DroppableWrapper';