"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RowAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _left = require("../../../../flyout/document_details/left");
var _kibana = require("../../../lib/kibana");
var _panel_keys = require("../../../../flyout/document_details/shared/constants/panel_keys");
var _use_experimental_features = require("../../../hooks/use_experimental_features");
var _guided_onboarding_tour = require("../../guided_onboarding_tour");
var _tour_config = require("../../guided_onboarding_tour/tour_config");
var _telemetry = require("../../../lib/telemetry");
var _get_mapped_non_ecs_value = require("../../../utils/get_mapped_non_ecs_value");
var _user_privileges = require("../../user_privileges");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RowActionComponent = ({
  columnHeaders,
  controlColumn,
  data,
  disabled,
  index,
  isEventViewer,
  loadingEventIds,
  onRowSelected,
  onRuleChange,
  pageRowIndex,
  rowIndex,
  selectedEventIds,
  showCheckboxes,
  tabType,
  tableId,
  setEventsLoading,
  setEventsDeleted,
  width,
  refetch
}) => {
  const {
    data: timelineNonEcsData,
    ecs: ecsData,
    _id: eventId,
    _index: indexName
  } = data !== null && data !== void 0 ? data : {};
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    activeStep,
    isTourShown
  } = (0, _guided_onboarding_tour.useTourContext)();
  const shouldFocusOnOverviewTab = (activeStep === _tour_config.AlertsCasesTourSteps.expandEvent || activeStep === _tour_config.AlertsCasesTourSteps.reviewAlertDetailsFlyout) && isTourShown(_tour_config.SecurityStepId.alertsCases);
  const columnValues = (0, _react.useMemo)(() => timelineNonEcsData && columnHeaders.map(header => {
    var _getMappedNonEcsValue;
    return (_getMappedNonEcsValue = (0, _get_mapped_non_ecs_value.getMappedNonEcsValue)({
      data: timelineNonEcsData,
      fieldName: header.id
    })) !== null && _getMappedNonEcsValue !== void 0 ? _getMappedNonEcsValue : [];
  }).join(' '), [columnHeaders, timelineNonEcsData]);
  const securitySolutionNotesDisabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('securitySolutionNotesDisabled');
  const {
    notesPrivileges: {
      read: canReadNotes
    },
    timelinePrivileges: {
      read: canReadTimelines
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const showNotes = canReadNotes && !securitySolutionNotesDisabled;
  const handleOnEventDetailPanelOpened = (0, _react.useCallback)(() => {
    openFlyout({
      right: {
        id: _panel_keys.DocumentDetailsRightPanelKey,
        path: shouldFocusOnOverviewTab ? {
          tab: 'overview'
        } : undefined,
        params: {
          id: eventId,
          indexName,
          scopeId: tableId
        }
      }
    });
    telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
      location: tableId,
      panel: 'right'
    });
  }, [eventId, indexName, tableId, openFlyout, shouldFocusOnOverviewTab, telemetry]);
  const toggleShowNotes = (0, _react.useCallback)(() => {
    openFlyout({
      right: {
        id: _panel_keys.DocumentDetailsRightPanelKey,
        params: {
          id: eventId,
          indexName,
          scopeId: tableId
        }
      },
      left: {
        id: _panel_keys.DocumentDetailsLeftPanelKey,
        path: {
          tab: _left.LeftPanelNotesTab
        },
        params: {
          id: eventId,
          indexName,
          scopeId: tableId
        }
      }
    });
    telemetry.reportEvent(_telemetry.NotesEventTypes.OpenNoteInExpandableFlyoutClicked, {
      location: tableId
    });
    telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
      location: tableId,
      panel: 'left'
    });
  }, [eventId, indexName, openFlyout, tableId, telemetry]);
  const Action = controlColumn.rowCellRender;
  if (!timelineNonEcsData || !ecsData || !eventId) {
    return /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "noData"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Action && /*#__PURE__*/_react.default.createElement(Action, {
    ariaRowindex: pageRowIndex + 1,
    checked: Object.keys(selectedEventIds).includes(eventId),
    columnId: controlColumn.id || '',
    columnValues: columnValues || '',
    data: timelineNonEcsData,
    "data-test-subj": "actions",
    disabled: disabled,
    ecsData: ecsData,
    eventId: eventId,
    index: index,
    isEventViewer: isEventViewer,
    loadingEventIds: loadingEventIds,
    onEventDetailsPanelOpened: handleOnEventDetailPanelOpened,
    onRowSelected: onRowSelected,
    onRuleChange: onRuleChange,
    rowIndex: rowIndex,
    showCheckboxes: showCheckboxes,
    tabType: tabType,
    timelineId: tableId,
    toggleShowNotes: securitySolutionNotesDisabled ? undefined : toggleShowNotes,
    width: width,
    setEventsLoading: setEventsLoading,
    setEventsDeleted: setEventsDeleted,
    refetch: refetch,
    showNotes: showNotes,
    disableTimelineAction: !canReadTimelines
  }));
};
const RowAction = exports.RowAction = /*#__PURE__*/_react.default.memo(RowActionComponent);