"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("./translations"));
var _schedule = _interopRequireDefault(require("../icons/schedule.svg"));
var _create_flyout = require("../create_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyPage = exports.EmptyPage = /*#__PURE__*/_react.default.memo(() => {
  // showing / hiding the flyout:
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const openFlyout = (0, _react.useCallback)(() => setShowFlyout(true), []);
  const onClose = (0, _react.useCallback)(() => setShowFlyout(false), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    "data-test-subj": "emptySchedule"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    css: (0, _react2.css)`
              text-align: center;
            `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: "128",
    src: _schedule.default,
    alt: i18n.SCHEDULE_ATTACK_DISCOVERY_ALT
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h2", null, i18n.EMPTY_PAGE_TITLE), /*#__PURE__*/_react.default.createElement("p", null, i18n.EMPTY_PAGE_DESCRIPTION))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "createSchedule",
    fill: true,
    onClick: openFlyout,
    size: "m",
    iconType: "plusInCircle"
  }, i18n.CREATE_SCHEDULE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    external: true,
    "data-test-subj": "learnMoreLink",
    href: "https://www.elastic.co/guide/en/security/current/attack-discovery.html",
    target: "_blank"
  }, i18n.LEARN_MORE)))))), showFlyout && /*#__PURE__*/_react.default.createElement(_create_flyout.CreateFlyout, {
    onClose: onClose
  }));
});
EmptyPage.displayName = 'EmptyPage';