"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScheduleExecutionLogs = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../../../../common/lib/kibana");
var _use_fetch_schedule_rule_type = require("../../logic/use_fetch_schedule_rule_type");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const css = {
  minHeight: 600
};
const ScheduleExecutionLogs = exports.ScheduleExecutionLogs = /*#__PURE__*/_react.default.memo(({
  schedule
}) => {
  const {
    triggersActionsUi: {
      getRuleEventLogList: RuleEventLogList
    }
  } = (0, _kibana.useKibana)().services;
  const {
    data: scheduleRuleType
  } = (0, _use_fetch_schedule_rule_type.useFetchScheduleRuleType)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "executionLogsTitle",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, i18n.EXECUTION_LOGS_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: css,
    direction: 'column',
    "data-test-subj": 'executionEventLogs'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, scheduleRuleType && /*#__PURE__*/_react.default.createElement(RuleEventLogList, {
    ruleId: schedule.id,
    ruleType: scheduleRuleType
  }))));
});
ScheduleExecutionLogs.displayName = 'ScheduleExecutionLogs';