"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Current = void 0;
var _eui = require("@elastic/eui");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _attack_discovery_panel = require("../attack_discovery_panel");
var _empty_states = require("../empty_states");
var _show_empty_states = require("../empty_states/helpers/show_empty_states");
var _helpers = require("../../helpers");
var _loading_callout = require("../../loading_callout");
var _summary = require("../summary");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_SELECTED_ATTACK_DISCOVERIES = {}; // constant reference to avoid re-renders
const EMPTY_SELECTED_CONNECTOR_ATTACK_DISCOVERIES = []; // constant reference to avoid re-renders

const CurrentComponent = ({
  aiConnectorsCount,
  alertsContextCount,
  alertsCount,
  approximateFutureTime,
  attackDiscoveriesCount,
  connectorId,
  connectorIntervals,
  end,
  failureReason,
  isLoading,
  isLoadingPost,
  loadingConnectorId,
  localStorageAttackDiscoveryMaxAlerts,
  onGenerate,
  onToggleShowAnonymized,
  selectedConnectorAttackDiscoveries,
  selectedConnectorLastUpdated,
  selectedConnectorReplacements,
  showAnonymized,
  start,
  stats
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "none",
  justifyContent: "spaceBetween"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true
}, (0, _helpers.showSummary)(attackDiscoveriesCount) && /*#__PURE__*/_react.default.createElement(_summary.Summary, {
  alertsCount: alertsCount,
  attackDiscoveriesCount: attackDiscoveriesCount,
  lastUpdated: selectedConnectorLastUpdated,
  onToggleShowAnonymized: onToggleShowAnonymized,
  selectedAttackDiscoveries: EMPTY_SELECTED_ATTACK_DISCOVERIES,
  selectedConnectorAttackDiscoveries: EMPTY_SELECTED_CONNECTOR_ATTACK_DISCOVERIES,
  setSelectedAttackDiscoveries: _fp.noop,
  showAnonymized: showAnonymized
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), (0, _helpers.showLoading)({
  attackDiscoveriesCount,
  connectorId,
  isLoading: isLoading || isLoadingPost,
  loadingConnectorId
}) ? /*#__PURE__*/_react.default.createElement(_loading_callout.LoadingCallout, {
  alertsContextCount: alertsContextCount,
  approximateFutureTime: approximateFutureTime,
  connectorIntervals: connectorIntervals,
  end: end,
  localStorageAttackDiscoveryMaxAlerts: localStorageAttackDiscoveryMaxAlerts,
  start: start
}) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _show_empty_states.showEmptyStates)({
  aiConnectorsCount,
  alertsContextCount,
  attackDiscoveriesCount,
  connectorId,
  failureReason,
  isLoading
}) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xxl"
}), /*#__PURE__*/_react.default.createElement(_empty_states.EmptyStates, {
  aiConnectorsCount: aiConnectorsCount,
  alertsContextCount: alertsContextCount,
  attackDiscoveriesCount: attackDiscoveriesCount,
  failureReason: failureReason,
  connectorId: connectorId,
  isLoading: isLoading || isLoadingPost,
  onGenerate: onGenerate,
  upToAlertsCount: Number(localStorageAttackDiscoveryMaxAlerts !== null && localStorageAttackDiscoveryMaxAlerts !== void 0 ? localStorageAttackDiscoveryMaxAlerts : _elasticAssistant.DEFAULT_ATTACK_DISCOVERY_MAX_ALERTS)
})) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedConnectorAttackDiscoveries.map((attackDiscovery, i) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
  key: attackDiscovery.id
}, /*#__PURE__*/_react.default.createElement(_attack_discovery_panel.AttackDiscoveryPanel, {
  attackDiscovery: attackDiscovery,
  isSelected: false,
  initialIsOpen: (0, _helpers.getInitialIsOpen)(i),
  setSelectedAttackDiscoveries: _fp.noop,
  showAnonymized: showAnonymized,
  replacements: selectedConnectorReplacements
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}))))));
CurrentComponent.displayName = 'CurrentComponent';
const Current = exports.Current = /*#__PURE__*/_react.default.memo(CurrentComponent);