"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RAN_SUCCESSFULLY_VIA_WITH_DISCOVERIES_COUNT = exports.RAN_SUCCESSFULLY_VIA_NO_DISCOVERIES_COUNT = exports.NO_MATCHING_ALERTS_VIA = exports.INFORMATION = exports.FAILED_VIA = exports.CLOSE = exports.CANCELED_VIA = exports.ATTACK_DISCOVERY_GENERATION_IN_PROGRESS_VIA = exports.ATTACK_DISCOVERY_GENERATION_IN_PROGRESS = exports.AI_IS_CURRENTLY_ANALYZING_RANGE = exports.AI_IS_CURRENTLY_ANALYZING_FROM = exports.AI_IS_CURRENTLY_ANALYZING = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AI_IS_CURRENTLY_ANALYZING = alertsCount => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.loadingCallout.aiIsCurrentlyAnalyzing', {
  defaultMessage: `AI is analyzing up to {alertsCount} {alertsCount, plural, =1 {alert} other {alerts}} in the last 24 hours to generate discoveries.`,
  values: {
    alertsCount
  }
});
exports.AI_IS_CURRENTLY_ANALYZING = AI_IS_CURRENTLY_ANALYZING;
const AI_IS_CURRENTLY_ANALYZING_FROM = ({
  alertsCount,
  from
}) => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.loadingCallout.aiIsCurrentlyAnalyzingFromLabel', {
  defaultMessage: `AI is analyzing up to {alertsCount} {alertsCount, plural, =1 {alert} other {alerts}} {from} to generate discoveries.`,
  values: {
    alertsCount,
    from
  }
});
exports.AI_IS_CURRENTLY_ANALYZING_FROM = AI_IS_CURRENTLY_ANALYZING_FROM;
const AI_IS_CURRENTLY_ANALYZING_RANGE = ({
  alertsCount,
  end,
  start
}) => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.loadingCallout.aiIsCurrentlyAnalyzingRangeLabel', {
  defaultMessage: `AI is analyzing up to {alertsCount} {alertsCount, plural, =1 {alert} other {alerts}} from {start} to {end} to generate discoveries.`,
  values: {
    alertsCount,
    end,
    start
  }
});
exports.AI_IS_CURRENTLY_ANALYZING_RANGE = AI_IS_CURRENTLY_ANALYZING_RANGE;
const ATTACK_DISCOVERY_GENERATION_IN_PROGRESS = exports.ATTACK_DISCOVERY_GENERATION_IN_PROGRESS = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.loadingCallout.attackDiscoveryGenerationInProgressLabel', {
  defaultMessage: 'Attack discovery in progress'
});
const ATTACK_DISCOVERY_GENERATION_IN_PROGRESS_VIA = connectorName => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.loadingCallout.attackDiscoveryGenerationInProgressViaLabel', {
  defaultMessage: 'Attack discovery in progress via {connectorName}',
  values: {
    connectorName
  }
});
exports.ATTACK_DISCOVERY_GENERATION_IN_PROGRESS_VIA = ATTACK_DISCOVERY_GENERATION_IN_PROGRESS_VIA;
const CANCELED_VIA = ({
  connectorName,
  formattedGenerationEndTime
}) => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.loadingCallout.canceledViaLabel', {
  defaultMessage: 'Attack discovery was canceled{connectorName, select, undefined {} other { for {connectorName}}}{formattedGenerationEndTime, select, undefined {} other { at {formattedGenerationEndTime}}}.',
  values: {
    connectorName,
    formattedGenerationEndTime
  }
});
exports.CANCELED_VIA = CANCELED_VIA;
const CLOSE = exports.CLOSE = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.loadingCallout.closeButtonLabel', {
  defaultMessage: 'Close'
});
const INFORMATION = exports.INFORMATION = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.loadingCallout.informationButtonLabel', {
  defaultMessage: 'Information'
});
const NO_MATCHING_ALERTS_VIA = ({
  connectorName,
  formattedGenerationEndTime
}) => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.loadingCallout.noMatchingAlertsViaLabel', {
  defaultMessage: 'Attack discovery ran successfully{connectorName, select, undefined {} other { via {connectorName}}}{formattedGenerationEndTime, select, undefined {} other { at {formattedGenerationEndTime}}}. There were no matching alerts in the configured time range.',
  values: {
    connectorName,
    formattedGenerationEndTime
  }
});
exports.NO_MATCHING_ALERTS_VIA = NO_MATCHING_ALERTS_VIA;
const RAN_SUCCESSFULLY_VIA_NO_DISCOVERIES_COUNT = ({
  connectorName,
  formattedGenerationEndTime
}) => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.loadingCallout.ranSuccessfullyNoDiscoveriesCountLabel', {
  defaultMessage: 'Attack discovery ran successfully{connectorName, select, undefined {} other { via {connectorName}}}{formattedGenerationEndTime, select, undefined {} other { at {formattedGenerationEndTime}}}. Refresh to view the results.',
  values: {
    connectorName,
    formattedGenerationEndTime
  }
});
exports.RAN_SUCCESSFULLY_VIA_NO_DISCOVERIES_COUNT = RAN_SUCCESSFULLY_VIA_NO_DISCOVERIES_COUNT;
const RAN_SUCCESSFULLY_VIA_WITH_DISCOVERIES_COUNT = ({
  connectorName,
  discoveries,
  formattedGenerationEndTime
}) => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.loadingCallout.ranSuccessfullyWithDiscoveriesCountLabel', {
  defaultMessage: 'Attack discovery ran successfully{connectorName, select, undefined {} other { via {connectorName}}}{formattedGenerationEndTime, select, undefined {} other { at {formattedGenerationEndTime}}}{discoveries, plural, =0 { and 0 new attacks were discovered.} =1 { and 1 new attack was discovered. Refresh to view the results.} other { and {discoveries} new attacks were discovered. Refresh to view the results.}}',
  values: {
    connectorName,
    discoveries,
    formattedGenerationEndTime
  }
});
exports.RAN_SUCCESSFULLY_VIA_WITH_DISCOVERIES_COUNT = RAN_SUCCESSFULLY_VIA_WITH_DISCOVERIES_COUNT;
const FAILED_VIA = ({
  connectorName,
  formattedGenerationEndTime
}) => _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.pages.loadingCallout.failedVia', {
  defaultMessage: 'Attack discovery failed{connectorName, select, undefined {} other { via {connectorName}}}{formattedGenerationEndTime, select, undefined {} other { at {formattedGenerationEndTime}}}.',
  values: {
    connectorName,
    formattedGenerationEndTime
  }
});
exports.FAILED_VIA = FAILED_VIA;