"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FailureAccordion = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FailureAccordionComponent = ({
  failureReason
}) => {
  const [firstFailure, ...restFailures] = (0, _react.useMemo)(() => failureReason != null ? failureReason.split('\n') : '', [failureReason]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, restFailures.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "failureAccordion",
    buttonContent: firstFailure,
    "data-test-subj": "failuresAccordion",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, restFailures.map((failure, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    key: i,
    paddingSize: "m"
  }, failure)))) : /*#__PURE__*/_react.default.createElement("p", null, firstFailure));
};
FailureAccordionComponent.displayName = 'FailureAccordion';
const FailureAccordion = exports.FailureAccordion = /*#__PURE__*/_react.default.memo(FailureAccordionComponent);