"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _app = require("./app");
var _app_routes = require("./app_routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderApp = ({
  element,
  history,
  services,
  store,
  usageCollection,
  subPluginRoutes,
  theme$,
  children
}) => {
  var _usageCollection$comp;
  const ApplicationUsageTrackingProvider = (_usageCollection$comp = usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.components.ApplicationUsageTrackingProvider) !== null && _usageCollection$comp !== void 0 ? _usageCollection$comp : _react.default.Fragment;
  (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_app.SecurityApp, {
    history: history,
    services: services,
    store: store,
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(ApplicationUsageTrackingProvider, null, children !== null && children !== void 0 ? children : subPluginRoutes && /*#__PURE__*/_react.default.createElement(_app_routes.AppRoutes, {
    subPluginRoutes: subPluginRoutes,
    services: services
  }))), element);
  return () => {
    services.data.search.session.clear();
    (0, _reactDom.unmountComponentAtNode)(element);
  };
};
exports.renderApp = renderApp;