"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createShowTopNCellActionFactory = void 0;
var _i18n = require("@kbn/i18n");
var _actions = require("@kbn/cell-actions/actions");
var _esQuery = require("@kbn/es-query");
var _fp = require("lodash/fp");
var _utils = require("../../utils");
var _constants = require("../../constants");
var _lens = require("../../../../common/utils/lens");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SHOW_TOP = fieldName => _i18n.i18n.translate('xpack.securitySolution.actions.showTopTooltip', {
  values: {
    fieldName
  },
  defaultMessage: `Show top {fieldName}`
});
const ICON = 'visBarVertical';
const createShowTopNCellActionFactory = exports.createShowTopNCellActionFactory = (0, _actions.createCellActionFactory)(({
  services
}) => ({
  type: _constants.SecurityCellActionType.SHOW_TOP_N,
  getIconType: () => ICON,
  getDisplayName: ({
    data
  }) => {
    var _data$;
    return SHOW_TOP((_data$ = data[0]) === null || _data$ === void 0 ? void 0 : _data$.field.name);
  },
  getDisplayNameTooltip: ({
    data
  }) => {
    var _data$2;
    return SHOW_TOP((_data$2 = data[0]) === null || _data$2 === void 0 ? void 0 : _data$2.field.name);
  },
  isCompatible: async ({
    data
  }) => {
    var _data$3;
    const field = (_data$3 = data[0]) === null || _data$3 === void 0 ? void 0 : _data$3.field;
    return data.length === 1 && (0, _utils.fieldHasCellActions)(field.name) && (0, _lens.isLensSupportedType)(field.type) && !(0, _esQuery.isDataViewFieldSubtypeNested)(field) && !!field.aggregatable;
  },
  execute: async context => {
    var _context$metadata;
    const firstItem = (0, _fp.first)(context.data);
    if (!context.nodeRef.current || !firstItem) return;
    services.topValuesPopover.showPopover({
      fieldName: firstItem.field.name,
      scopeId: (_context$metadata = context.metadata) === null || _context$metadata === void 0 ? void 0 : _context$metadata.scopeId,
      nodeRef: context.nodeRef.current
    });
  }
}));